% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.R
\name{gg.inla.mesh}
\alias{gg.inla.mesh}
\title{Geom for inla.mesh objects}
\usage{
\method{gg}{inla.mesh}(
  data,
  color = NULL,
  alpha = NULL,
  edge.color = "grey",
  edge.linewidth = 0.25,
  interior = TRUE,
  int.color = "blue",
  int.linewidth = 0.5,
  exterior = TRUE,
  ext.color = "black",
  ext.linewidth = 1,
  crs = NULL,
  mask = NULL,
  nx = 500,
  ny = 500,
  ...
)
}
\arguments{
\item{data}{An \code{inla.mesh} object.}

\item{color}{A vector of scalar values to fill the mesh with colors.
The length of the vector mus correspond to the number of mesh vertices.
The alternative name \code{colour} is also recognised.}

\item{alpha}{A vector of scalar values setting the alpha value of the colors provided.}

\item{edge.color}{Color of the regular mesh edges.}

\item{edge.linewidth}{Line width for the regular mesh edges. Default 0.25}

\item{interior}{If TRUE, plot the interior boundaries of the mesh.}

\item{int.color}{Color used to plot the interior constraint edges.}

\item{int.linewidth}{Line width for the interior constraint edges. Default 0.5}

\item{exterior}{If TRUE, plot the exterior boundaries of the mesh.}

\item{ext.color}{Color used to plot the exterior boundary edges.}

\item{ext.linewidth}{Line width for the exterior boundary edges. Default 1}

\item{crs}{A CRS object supported by \code{\link[=fm_transform]{fm_transform()}} defining the coordinate
system to project the mesh to before plotting.}

\item{mask}{A SpatialPolygon defining the region that is plotted.}

\item{nx}{Number of pixels in x direction (when plotting using the color parameter).}

\item{ny}{Number of pixels in y direction (when plotting using the color parameter).}

\item{...}{ignored arguments (S3 generic compatibility).}
}
\value{
\code{geom_line} return values or, if the color argument is used, the
values of \code{\link[=gg.SpatialPixelsDataFrame]{gg.SpatialPixelsDataFrame()}}.
}
\description{
This function extracts the graph of an inla.mesh object and uses \code{geom_line} to visualize
the graph's edges. Alternatively, if the \code{color} argument is provided, interpolates the colors
across for a set of SpatialPixels covering the mesh area and calls \code{\link[=gg.SpatialPixelsDataFrame]{gg.SpatialPixelsDataFrame()}}
to plot the interpolation.
Requires the \code{ggplot2} package.
}
\examples{
\donttest{
if (bru_safe_inla() &&
    require(ggplot2, quietly = TRUE)) {

  # Load Gorilla data
  data("gorillas", package = "inlabru")

  # Plot mesh using default edge colors

  ggplot() +
    gg(gorillas$mesh)

  # Don't show interior and exterior boundaries

  ggplot() +
    gg(gorillas$mesh, interior = FALSE, exterior = FALSE)

  # Change the edge colors

  ggplot() +
    gg(gorillas$mesh,
      edge.color = "green",
      int.color = "black",
      ext.color = "blue"
    )

  # Use the x-coordinate of the vertices to colorize the triangles and
  # mask the plotted area by the survey boundary, i.e. only plot the inside

  xcoord <- gorillas$mesh$loc[, 1]
  ggplot() +
    gg(gorillas$mesh, color = (xcoord - 580), mask = gorillas$boundary) +
    gg(gorillas$boundary)
}
}
}
\seealso{
Other geomes for meshes: 
\code{\link{gg.inla.mesh.1d}()},
\code{\link{gg}()},
\code{\link{gm}()}
}
\concept{geomes for meshes}
