% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_profiles.R
\name{aggregate_profiles}
\alias{aggregate_profiles}
\title{Aggregates Ceteris Paribus Profiles}
\usage{
aggregate_profiles(
  x,
  ...,
  variable_type = "numerical",
  groups = NULL,
  type = "partial",
  variables = NULL,
  span = 0.25,
  center = FALSE
)
}
\arguments{
\item{x}{a ceteris paribus explainer produced with function \code{ceteris_paribus()}}

\item{...}{other explainers that shall be calculated together}

\item{variable_type}{a character. If \code{numerical} then only numerical variables will be calculated.
If \code{categorical} then only categorical variables will be calculated.}

\item{groups}{a variable name that will be used for grouping.
By default \code{NULL} which means that no groups shall be calculated}

\item{type}{either \code{partial/conditional/accumulated} for partial dependence, conditional profiles of accumulated local effects}

\item{variables}{if not \code{NULL} then aggregate only for selected \code{variables} will be calculated}

\item{span}{smoothing coeffcient, by default \code{0.25}.It's the sd for gaussian kernel}

\item{center}{by default accumulated profiles start at 0. if \code{center=TRUE} then they are centered around average response}
}
\value{
an object of the class \code{aggregated_profiles_explainer}
}
\description{
The function \code{aggregate_profiles()} calculates an aggregate of ceteris paribus profiles.
It can be: Partial Dependence Profile (average across Ceteris Paribus Profiles),
Conditional Dependence Profile (local weighted average across Ceteris Paribus Profiles) or
Accumulated Local Dependence Profile (cummulated average local changes in Ceteris Paribus Profiles).
}
\examples{
library("DALEX")
library("randomForest")

model_titanic_rf <- randomForest(survived ~ .,  data = titanic_imputed)

explain_titanic_rf <- explain(model_titanic_rf,
                              data = titanic_imputed[,-8],
                              y = titanic_imputed[,8])

selected_passangers <- select_sample(titanic_imputed, n = 100)
cp_rf <- ceteris_paribus(explain_titanic_rf, selected_passangers)
head(cp_rf)

# continouse variable
pdp_rf_p <- aggregate_profiles(cp_rf, variables = "age", type = "partial")
pdp_rf_p$`_label_` <- "RF_partial"
pdp_rf_c <- aggregate_profiles(cp_rf, variables = "age", type = "conditional")
pdp_rf_c$`_label_` <- "RF_conditional"
pdp_rf_a <- aggregate_profiles(cp_rf, variables = "age", type = "accumulated")
pdp_rf_a$`_label_` <- "RF_accumulated"

plot(pdp_rf_p, pdp_rf_c, pdp_rf_a, color = "_label_")

\donttest{
pdp_rf <- aggregate_profiles(cp_rf, variables = "age",
                             groups = "gender")

head(pdp_rf)
plot(cp_rf, variables = "age") +
  show_observations(cp_rf, variables = "age") +
  show_rugs(cp_rf, variables = "age", color = "red") +
  show_aggregated_profiles(pdp_rf, size = 3, color = "_label_")

# categorical variable
pdp_rf_p <- aggregate_profiles(cp_rf, variables = "class",
                               variable_type = "categorical",  type = "partial")
pdp_rf_p$`_label_` <- "RF_partial"
pdp_rf_c <- aggregate_profiles(cp_rf, variables = "class",
                               variable_type = "categorical", type = "conditional")
pdp_rf_c$`_label_` <- "RF_conditional"
pdp_rf_a <- aggregate_profiles(cp_rf, variables = "class",
                               variable_type = "categorical", type = "accumulated")
pdp_rf_a$`_label_` <- "RF_accumulated"
plot(pdp_rf_p, pdp_rf_c, pdp_rf_a, color = "_label_")

# or maybe flipped?
library(ggplot2)
plot(pdp_rf_p, pdp_rf_c, pdp_rf_a, color = "_label_") + coord_flip()

pdp_rf <- aggregate_profiles(cp_rf, variables = "class", variable_type = "categorical",
                             groups = "gender")
head(pdp_rf)
plot(pdp_rf, variables = "class")
# or maybe flipped?
plot(pdp_rf, variables = "class") + coord_flip()

}

}
\references{
Explanatory Model Analysis. Explore, Explain and Examine Predictive Models. \url{https://pbiecek.github.io/ema}
}
