% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getVMat.onePhase.R
\name{getVMat.onePhase}
\alias{getVMat.onePhase}
\title{Get the Variance Matrices for Single-Phase experiment}
\usage{
getVMat.onePhase(Z.Phase1, design.df, var.comp = NA)
}
\arguments{
\item{Z.Phase1}{a list of block design matrix from \code{makeBlkDesMat}
function from Phase 1 block structure.}

\item{design.df}{a data frame containing the experimental design. Requires
every column be a \code{\link{factor}}.}

\item{var.comp}{a vector of characters containing the variance components
of interest this allows the user to specify the variance components to be
shown on the ANOVA table. This also allows the user to specify artificial
stratum to facilitate decomposition. Default is \code{NA}, which uses every
random factor as the variance components with the first phase's variance
components in appear before the second phase's variance components.}
}
\value{
A list of matrices.
}
\description{
Construct the matrix for each variance components for the single-phase or
two-phase experiment.
}
\examples{

 design1 <- local({ 
    Ani = as.factor(LETTERS[c(1,2,3,4,
                              5,6,7,8)])
    Trt = as.factor(letters[c(1,1,1,1,
                              2,2,2,2)])
    data.frame(Ani, Trt, stringsAsFactors = TRUE )
  })

    blk.str = "Ani"
    
		rT = terms(as.formula(paste("~", blk.str, sep = "")), keep.order = TRUE) 

    blkTerm = attr(rT,"term.labels")
		Z = makeBlkDesMat(design1, rev(attr(rT,"term.labels")))

    V = getVMat.onePhase(Z, design1)
    

}
\author{
Kevin Chang
}
