% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infer-chisq-assoc-test.R
\name{infer_chisq_assoc_test}
\alias{infer_chisq_assoc_test}
\alias{chisq_test}
\title{Chi Square Test of Association}
\usage{
infer_chisq_assoc_test(data, x, y)
}
\arguments{
\item{data}{a \code{data.frame} or \code{tibble}}

\item{x}{factor; column in \code{data}}

\item{y}{factor; column in \code{data}}
}
\value{
\code{infer_chisq_assoc_test} returns an object of class
\code{"infer_chisq_assoc_test"}. An object of class
\code{"infer_chisq_assoc_test"} is a list containing the
following components:

\item{chi}{chi square}
\item{chilr}{likelihood ratio chi square}
\item{chimh}{mantel haenszel chi square}
\item{chiy}{continuity adjusted chi square}
\item{sig}{p-value of chi square}
\item{siglr}{p-value of likelihood ratio chi square}
\item{sigmh}{p-value of mantel haenszel chi square}
\item{sigy}{p-value of continuity adjusted chi square}
\item{phi}{phi coefficient}
\item{cc}{contingency coefficient}
\item{cv}{cramer's v}
\item{ds}{product of dimensions of the table of \code{x} and \code{y}}
\item{df}{degrees of freedom}
}
\description{
Chi Square test of association to examine if there is a
relationship between two categorical variables.
}
\section{Deprecated Function}{

\code{chisq_test()} has been deprecated. Instead use
\code{infer_chisq_assoc_test()}.
}

\examples{
infer_chisq_assoc_test(hsb, female, schtyp)

infer_chisq_assoc_test(hsb, female, ses)
}
\references{
Sheskin, D. J. 2007. Handbook of Parametric and Nonparametric
Statistical Procedures, 4th edition. : Chapman & Hall/CRC.
}
\seealso{
\code{\link[stats]{chisq.test}}
}
