% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify.R
\name{specify}
\alias{specify}
\title{Specify the response and explanatory variables}
\usage{
specify(x, formula, response = NULL, explanatory = NULL, success = NULL)
}
\arguments{
\item{x}{a data frame that can be coerced into a \code{\link[dplyr]{tbl_df}}}

\item{formula}{a formula with the response variable on the left and the explanatory on the right}

\item{response}{the variable name in \code{x} that will serve as the response. This is alternative to using the \code{formula} argument}

\item{explanatory}{the variable name in \code{x} that will serve as the explanatory variable}

\item{success}{the level of \code{response} that will be considered a success, as a string. Needed for inference on one proportion or a difference in proportions}
}
\value{
A tibble containing the response (and explanatory, if specified) variable data
}
\description{
Specify the response and explanatory variables
}
\examples{
# One binary variable
  mtcars \%>\%
    dplyr::mutate(am = factor(am)) \%>\%
    specify(response = am, success = "1") \%>\%
    hypothesize(null = "point", p = 0.75) \%>\%
    generate(reps = 100, type = "simulate") \%>\%
    calculate(stat = "prop")

# Permutation test
  mtcars \%>\%
    dplyr::mutate(cyl = factor(cyl)) \%>\%
    specify(mpg ~ cyl) \%>\%
    hypothesize(null = "independence") \%>\%
    generate(reps = 100, type = "permute") \%>\%
    calculate(stat = "F")
}
