% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_numeric.R
\name{as_numeric}
\alias{as_numeric}
\alias{is_numeric}
\title{Test object for, or coerce to, numeric}
\usage{
as_numeric(x)

is_numeric(x)
}
\arguments{
\item{x}{object to be coerced or tested
(and return a logical vector of the same length) or should it test the whole 
vector as one object and return a logical vector of length one. (\code{TRUE} by default).}
}
\description{
\code{as_numeric} is essentially a wrapper to \code{as.numeric} except that objects of class factor are first coerced to character and then to numeric.
 \code{is_numeric} test if \code{x} is "somehow numeric" (see examples).
}
\examples{
df <- data.frame(v = c("46513", "45"))
class(df$v) # factor

# Note that
as.numeric(df$v) # 2 1
# but
as_numeric(df$v) # 46513    45

is_numeric(1) # TRUE
is_numeric("1") # TRUE
is_numeric(as.factor(1)) # TRUE
is_numeric(as.factor("khb")) # FALSE
}
