% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportr.R
\name{exportr}
\alias{exportr}
\title{Dump script together with functions from required packages}
\usage{
exportr(script = NULL, packages, recursive = TRUE,
  outfile = "./generated_r_script.R", force = FALSE)
}
\arguments{
\item{script}{connection with script (file) to append to function definitions}

\item{packages}{name of packages (as character) to be explicitly included.}

\item{recursive}{argument passed to \code{\link{package_dependencies}}}

\item{outfile}{filename for dump file}

\item{force}{this function works only in interactive mode by default but
output can be forced by this argument set to \code{TRUE}}
}
\value{
nothing (function called for its side effects)
}
\description{
If a package is not installed on the computer/server intended to run a
final script, this function can take the script and export it together with all
objects (functions, methods etcetera) from specified R packages. It might
thereafter be possible to transfer the script and to run it even if all
packages are not installed by the host.
}
\details{
Some packages use
external dependencies and/or compiled code. This is not handled by the
function. Hence, there is no guarantee that the script will actually work!
}
