% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats-utility.R
\name{geomMean}
\alias{geomMean}
\title{Compute geometric mean.}
\usage{
geomMean(x, na.rm = FALSE)
}
\arguments{
\item{x}{Numeric vector.}

\item{na.rm}{Logical, should NA value(s) be removed (FALSE by default)?}
}
\value{
Numeric vector of length 1 with geometric mean.
}
\description{
The geometric mean is computed as:
\eqn{\exp(\bar{log(x)})}, with:
\itemize{
\item{log: }{natural logarithm}
\item{\eqn{\bar{log(x)}}: }{arithmetic mean of log(x)}
}
}
\examples{
# geometric mean of a big sample from log normal distribution
# tends to the mean of the distribution:
geomMean(rlnorm(n = 1000, meanlog = 0, sdlog = 1))
}
\seealso{
Other stats utility functions: 
\code{\link{cv}()},
\code{\link{geomCV}()},
\code{\link{geomSD}()},
\code{\link{geomSE}()},
\code{\link{se}()}
}
\author{
Laure Cougnaud
}
\concept{stats utility functions}
