% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na_remove.R
\name{na_remove}
\alias{na_remove}
\title{Remove Missing Values}
\usage{
na_remove(x)
}
\arguments{
\item{x}{Numeric Vector (\code{\link{vector}}) or Time Series (\code{\link{ts}})
object in which missing values shall be replaced}
}
\value{
Vector (\code{\link{vector}})
}
\description{
Removes all missing values from a time series.
}
\details{
Removes all missing values from a input time series. This shortens
the time series by the number of missing values in the series. Should be
handled with care, because this can affect the seasonality of the time
series. Seasonal patterns might be destroyed. Independent from the input,
this function only returns a vector. (the time information of a resulting
time series object wouldn't be correct any more).
}
\examples{
# Example 1: Remove all NAs
# Create Time series with missing values
x <- ts(c(2, 3, NA, 5, 6, NA, 7, 8))

# Example 1: Remove all NAs
na_remove(x)

# Example 2: Remove all NAs in tsAirgap
na_remove(tsAirgap)

# Example 3: Same as example 1, just written with pipe operator
x \%>\% na_remove()

}
\seealso{
\code{\link[imputeTS]{na_interpolation}},
\code{\link[imputeTS]{na_kalman}}, \code{\link[imputeTS]{na_locf}},
 \code{\link[imputeTS]{na_ma}}, \code{\link[imputeTS]{na_mean}},
 \code{\link[imputeTS]{na_random}}, \code{\link[imputeTS]{na_replace}},
 \code{\link[imputeTS]{na_seadec}}, \code{\link[imputeTS]{na_seasplit}}
}
\author{
Steffen Moritz
}
