% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signal_processing.R
\name{filter_acc}
\alias{filter_acc}
\title{Filter the acceleration signal}
\usage{
filter_acc(data, order = 4, cutoff = 20, type = "lowpass")
}
\arguments{
\item{data}{An \code{impactr_data} object, as obtained with
\link[=read_acc]{read_acc()}.}

\item{order}{The order of the filter. Defaults to 4.}

\item{cutoff}{The filter cut-off frequency in Hz. Defaults to 20. For
low- and high-pass filters, must be a scalar. For band-pass and band-
stop, a vector of length two.}

\item{type}{The type of filter. Defaults to "lowpass". Can be "lowpass",
"highpass", "bandpass" or "bandstop".}
}
\value{
An object of class \code{impactr_data}.
}
\description{
Filter the acceleration signal using a butterworth digital filter.
}
\details{
The default values of the filter parameters are matching the filter
used in the paper by Veras et al. that developed the mechanical loading
prediction equations (see References).
}
\examples{
data <- read_acc(impactr_example("hip-raw.csv"))
filter_acc(data)
}
\references{
\itemize{
\item Veras L, Diniz-Sousa F, Boppre G, Devezas V, Santos-Sousa H, Preto J,
Machado L, Vilas- Boas JP, Oliveira J, Fonseca H. Accelerometer-based
prediction of skeletal mechanical loading during walking in normal weight
to severely obese subjects. Osteoporosis International. 2020. 31(7):1239-
1250. \doi{https://doi.org/10.1007/s00198-020-05295-2}.
}
}
