% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clonality.R
\name{repClonality}
\alias{repClonality}
\alias{clonality}
\alias{clonal.prop}
\alias{clonal_proportion}
\alias{top_proportion}
\alias{rare_proportion}
\alias{clonal_space_homeostasis}
\title{Clonality analysis of immune repertoires}
\usage{
repClonality(
  .data,
  .method = c("clonal.prop", "homeo", "top", "rare"),
  .perc = 10,
  .clone.types = c(Rare = 1e-05, Small = 1e-04, Medium = 0.001, Large = 0.01,
    Hyperexpanded = 1),
  .head = c(10, 100, 1000, 3000, 10000, 30000, 1e+05),
  .bound = c(1, 3, 10, 30, 100)
)
}
\arguments{
\item{.data}{The data to be processed. Can be \link{data.frame},
\link{data.table}, or a list of these objects.

Every object must have columns in the immunarch compatible format.
\link{immunarch_data_format}

Competent users may provide advanced data representations:
DBI database connections, Apache Spark DataFrame from \link{copy_to} or a list
of these objects. They are supported with the same limitations as basic objects.

Note: each connection must represent a separate repertoire.}

\item{.method}{A String with one of the following options: \code{"clonal.prop"},
\code{"homeo"}, \code{"top"} or \code{"rare"}.

Set \code{"clonal.prop"} to compute clonal proportions or in other words
percentage of clonotypes required to occupy specified by \code{.perc} percent
of the total immune repertoire.

Set \code{"homeo"} to analyse relative abundance (also known as clonal space homeostasis), which is defined as the
proportion of repertoire occupied by clonal groups with specific abundances..

Set \code{"top"} to estimate relative abundance for the groups of top clonotypes in
repertoire, e.g., ten most abundant clonotypes. Use \code{".head"} to define index intervals,
such as 10, 100 and so on.

Set \code{"rare"} to estimate relative abundance for the groups of rare clonotypes
with low counts. Use \code{".bound"} to define the threshold of clonotype groups.}

\item{.perc}{A single numerical value ranging from 0 to 100.}

\item{.clone.types}{A named numerical vector with the threshold of the half-closed
intervals that mark off clonal groups.}

\item{.head}{A numerical vector with ranges of the top clonotypes.}

\item{.bound}{A numerical vector with ranges of abundance for the rare clonotypes in
the dataset.}
}
\value{
If input data is a single immune repertoire, then the function returns a numeric vector
with clonality statistics.

Otherwise, it returns a numeric matrix with clonality statistics for all input repertoires.
}
\description{
\code{repClonality} function encompasses several methods to measure
clonal proportions in a given repertoire.
}
\details{
Clonal proportion assessment is a different approach to estimate
repertoire diversity. When visualised, it allows for thorough examination of
immune repertoire structure and composition.

In its core this type of analysis is similar to the relative species abundance
concept in ecology. Relative abundance is the percent composition of an organism
of a particular kind relative to the total number of organisms in the area.

A stacked barplot of relative clonotype abundances can be therefore viewed as
a non-parametric approach to comparing their underlying distributions.
}
\examples{
# Load the data
data(immdata)

imm_pr <- repClonality(immdata$data, .method = "clonal.prop")
vis(imm_pr)

imm_top <- repClonality(immdata$data, .method = "top", .head = c(10, 100, 1000, 3000, 10000))
vis(imm_top)

imm_rare <- repClonality(immdata$data, .method = "rare")
vis(imm_rare)

imm_hom <- repClonality(immdata$data, .method = "homeo")
vis(imm_hom)
}
\seealso{
\link{repDiversity}
}
\concept{clonality}
