% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis.R
\name{vis.immunr_kmeans}
\alias{vis.immunr_kmeans}
\alias{vis.immunr_dbscan}
\title{Visualisation of K-means and DBSCAN clustering}
\usage{
\method{vis}{immunr_kmeans}(
  .data,
  .point = TRUE,
  .text = TRUE,
  .ellipse = TRUE,
  .point.size = 2,
  .text.size = 10,
  .plot = c("clust", "best"),
  .return.grob = FALSE,
  ...
)
}
\arguments{
\item{.data}{Clustering results from \link{repOverlapAnalysis} or \link{geneUsageAnalysis}.}

\item{.point}{If TRUE then plot sample points. Passed to \link{fviz_cluster}.}

\item{.text}{If TRUE then plot text labels. Passed to \link{fviz_cluster}.}

\item{.ellipse}{If TRUE then plot ellipses around all samples. Passed to "ellipse" from \link{fviz_cluster}.}

\item{.point.size}{Size of points, passed to "pointsize" from \link{fviz_cluster}.}

\item{.text.size}{Size of text labels, passed to labelsize from \link{fviz_cluster}.}

\item{.plot}{A character vector of length one or two specifying which plots to visualise.
If "clust" then plot only the clustering. If "best" then plot the number of optimal clusters.
If both then plot both.}

\item{.return.grob}{If TRUE then return grob instead of plot.}

\item{...}{Not used here.}
}
\value{
Ggplot2 objects inside the gridExtra container.
}
\description{
Visualisation of the results of K-means and DBSCAN clustering.
For hierarhical clustering visualisations see \link{vis.immunr_hclust}.
}
\examples{
data(immdata)
ov <- repOverlap(immdata$data)
repOverlapAnalysis(ov, "mds+kmeans") \%>\% vis()

}
\seealso{
\link{vis}, \link{repOverlapAnalysis}, \link{geneUsageAnalysis}
}
\concept{post_analysis}
