% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdfos.R
\name{pdfos}
\alias{pdfos}
\title{Probability density function estimation based oversampling}
\usage{
pdfos(dataset, numInstances, classAttr = "Class")
}
\arguments{
\item{dataset}{\code{data.frame} to treat. All columns, except
\code{classAttr} one, have to be numeric or coercible to numeric.}

\item{numInstances}{Integer. Number of new minority examples to generate.}

\item{classAttr}{\code{character}. Indicates the class attribute from
\code{dataset}. Must exist in it.}
}
\value{
A \code{data.frame} with the same structure as \code{dataset},
  containing the generated synthetic examples.
}
\description{
Generates synthetic minority examples for a numerical dataset approximating a
Gaussian multivariate distribution which best fits the minority data.
}
\details{
To generate the synthetic data, it approximates a normal distribution with
mean a given example belonging to the minority class, and whose variance is
the minority class variance multiplied by a constant; that constant is
computed so that it minimizes the mean integrated squared error of a Gaussian
multivariate kernel function.
}
\examples{
data(iris0)

newSamples <- pdfos(iris0, numInstances = 100, classAttr = "Class")

}
\references{
Gao, Ming; Hong, Xia; Chen, Sheng; Harris, Chris J.; Khalaf, Emad. Pdfos: Pdf
Estimation Based Oversampling for Imbalanced Two-Class Problems.
Neurocomputing 138 (2014), p. 248–259

Silverman, B. W. Density Estimation for Statistics and Data Analysis. Chapman
& Hall, 1986. – ISBN 0412246201
}
