library(imagerExtra)
test_that("fuzzy thresholding",
{
    notim <- 1
    im <- boats
    gim <- grayscale(im)
    mat_gim <- as.matrix(gim)
    gim2 <- imrep(gim, 2) %>% imappend(., "z")
    im_NA <- as.cimg(matrix(NA, 100, 100))
    im_uniform <- as.cimg(matrix(1,100,100))
    bad1 <- "A"
    bad2 <- -1
    bad3 <- c(0.1,0.1,0.1)
    bad4 <- NA
    bad5 <- NULL
    
    expect_error(ThresholdFuzzy(notim))
    expect_error(ThresholdFuzzy(im))
    expect_error(ThresholdFuzzy(gim2))
    expect_error(ThresholdFuzzy(im_NA))
    expect_error(ThresholdFuzzy(im_uniform))
    expect_error(ThresholdFuzzy(gim, returnvalue = bad1))
    expect_error(ThresholdFuzzy(gim, returnvalue = bad2))
    expect_error(ThresholdFuzzy(gim, returnvalue = bad3))
    expect_error(ThresholdFuzzy(gim, returnvalue = bad4))
    expect_error(ThresholdFuzzy(gim, returnvalue = bad5))
    expect_error(ThresholdFuzzy(gim, n = bad1))
    expect_error(ThresholdFuzzy(gim, n = bad2))
    expect_error(ThresholdFuzzy(gim, n = bad3))
    expect_error(ThresholdFuzzy(gim, n = bad4))
    expect_error(ThresholdFuzzy(gim, n = bad5))    
   # expect_error(ThresholdFuzzy(gim, n = 1)) 
    expect_error(ThresholdFuzzy(gim, maxiter = bad1))
    expect_error(ThresholdFuzzy(gim, maxiter = bad2))
    expect_error(ThresholdFuzzy(gim, maxiter = bad3))
    expect_error(ThresholdFuzzy(gim, maxiter = bad4))
    expect_error(ThresholdFuzzy(gim, maxiter = bad5))    
    expect_error(ThresholdFuzzy(gim, maxiter = 1))
    expect_error(ThresholdFuzzy(gim, intervalnumber = bad1))
    expect_error(ThresholdFuzzy(gim, intervalnumber = bad2))
    expect_error(ThresholdFuzzy(gim, intervalnumber = bad3))
    expect_error(ThresholdFuzzy(gim, intervalnumber = bad4))
    expect_error(ThresholdFuzzy(gim, intervalnumber = bad5))    
    expect_error(ThresholdFuzzy(gim, intervalnumber = 1))
    expect_error(ThresholdFuzzy(gim, c1 = bad1))
    expect_error(ThresholdFuzzy(gim, c1 = bad2))
    expect_error(ThresholdFuzzy(gim, c1 = bad3))
    expect_error(ThresholdFuzzy(gim, c1 = bad4))
    expect_error(ThresholdFuzzy(gim, c1 = bad5))     
    expect_error(ThresholdFuzzy(gim, c2 = bad1))
    expect_error(ThresholdFuzzy(gim, c2 = bad2))
    expect_error(ThresholdFuzzy(gim, c2 = bad3))
    expect_error(ThresholdFuzzy(gim, c2 = bad4))
    expect_error(ThresholdFuzzy(gim, c2 = bad5))    
    expect_error(ThresholdFuzzy(gim, mutrate = bad1))
    expect_error(ThresholdFuzzy(gim, mutrate = bad2))
    expect_error(ThresholdFuzzy(gim, mutrate = bad3))
    expect_error(ThresholdFuzzy(gim, mutrate = bad4))
    expect_error(ThresholdFuzzy(gim, mutrate = bad5))    
    expect_error(ThresholdFuzzy(gim, vmaxcoef = bad1))
    expect_error(ThresholdFuzzy(gim, vmaxcoef = bad2))
    expect_error(ThresholdFuzzy(gim, vmaxcoef = bad3))
    expect_error(ThresholdFuzzy(gim, vmaxcoef = bad4))
    expect_error(ThresholdFuzzy(gim, vmaxcoef = bad5))
    expect_error(ThresholdFuzzy(gim, omegamax = bad1))
    expect_error(ThresholdFuzzy(gim, omegamax = bad2))
    expect_error(ThresholdFuzzy(gim, omegamax = bad3))
    expect_error(ThresholdFuzzy(gim, omegamax = bad4))
    expect_error(ThresholdFuzzy(gim, omegamax = bad5))    
    expect_error(ThresholdFuzzy(gim, omegamax = 1))
    expect_error(ThresholdFuzzy(gim, omegamin = bad1))
    expect_error(ThresholdFuzzy(gim, omegamin = bad2))
    expect_error(ThresholdFuzzy(gim, omegamin = bad3))
    expect_error(ThresholdFuzzy(gim, omegamin = bad4))
    expect_error(ThresholdFuzzy(gim, omegamin = bad5))    
    expect_error(ThresholdFuzzy(gim, omegamin = 1))  
    expect_error(ThresholdFuzzy(gim, omegamax = 0.2, omegamin = 0.5))    
})