% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deslant.R
\name{ocv_deslant}
\alias{ocv_deslant}
\alias{image_deslant}
\title{Deslant images by putting cursive text upright}
\usage{
ocv_deslant(image, bgcolor = 255, lower_bound = -1, upper_bound = 1)

image_deslant(image, bgcolor = 255, lower_bound = -1, upper_bound = 1)
}
\arguments{
\item{image}{an object of class opencv-image (for \code{ocv_deslant}) with pixel values between 0 and 255 or a magick-image (for \code{image_deslant})}

\item{bgcolor}{integer value with the background color to use to fill the gaps of the sheared image that is returned. Defaults to white: 255}

\item{lower_bound}{lower bound of shear values. Defaults to -1}

\item{upper_bound}{upper bound of shear values. Defaults to 1}
}
\value{
an object of class opencv-image or magick-image with the deslanted image
}
\description{
This algorithm sets handwritten text in images upright by removing cursive writing style. 
One can use it as a preprocessing step for handwritten text recognition.\cr
\itemize{
\item{\code{image_deslant} expects a magick-image and performs grayscaling before doing deslanting}
\item{\code{ocv_deslant} expects a ocv-image and does not perform grayscaling before doing deslanting}
}
}
\examples{
\donttest{
\dontshow{
if(require(opencv)) \{
}
library(magick)
library(opencv)
library(image.textlinedetector)
path <- system.file(package = "image.textlinedetector", "extdata", "cursive.png")
img  <- ocv_read(path)
img  <- ocv_grayscale(img)
img
up   <- ocv_deslant(img)
up

img  <- image_read(path)
img
image_deslant(img)
\dontshow{
\}
# End of main if statement running only if the required packages are installed
}
}
}
