% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{display}
\alias{display}
\title{Basic image display.}
\usage{
display(img, method = NULL, basic = FALSE, normalize = TRUE)
}
\arguments{
\item{img}{An \link{ijtiff_img} object.}

\item{method}{The way of displaying images. Defaults to "browser" when R is
used interactively, and to "raster" otherwise. The default behavior can be
overridden by setting options("EBImage.display"). This has no effect when
\code{basic = TRUE}.}

\item{basic}{Force the basic (non-\code{EBImage}) display.}

\item{normalize}{Normalize the image before displaying (for better contrast)?
This only has an effect if the EBImage functionality is used. The basic
display always normalizes.}
}
\description{
Display an image that has been read in by \code{\link[=read_tif]{read_tif()}} as it would look in
'ImageJ'. This function is really just \code{\link[EBImage:display]{EBImage::display()}} on the inside. If
you do not have \code{EBImage} installed, a more basic display is offered.
}
\examples{
img <- read_tif(system.file("img", "Rlogo.tif", package = "ijtiff"))
display(img)
display(img[, , 1, 1])  # first (red) channel, first frame
display(img[, , 2, ])  # second (green) channel, first frame
display(img[, , 3, ])  # third (blue) channel, first frame
display(img, basic = TRUE)  # displays first (red) channel, first frame

}
