% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cliques.R
\name{weighted_cliques}
\alias{weighted_cliques}
\alias{largest_weighted_cliques}
\alias{max_weighted_cliques}
\alias{count_max_weighted_cliques}
\alias{weighted_clique_num}
\title{Functions to find weighted cliques, i.e. weighted complete subgraphs in a graph}
\usage{
weighted_cliques(
  graph,
  vertex.weights = NULL,
  min.weight = 0,
  max.weight = 0,
  maximal = FALSE
)
}
\arguments{
\item{graph}{The input graph, directed graphs will be considered as
undirected ones, multiple edges and loops are ignored.}

\item{vertex.weights}{Vertex weight vector. If the graph has a \code{weight}
vertex attribute, then this is used by default. If the graph does not have a
\code{weight} vertex attribute and this argument is \code{NULL}, then every
vertex is assumed to have a weight of 1. Note that the current implementation
of the weighted clique finder supports positive integer weights only.}

\item{min.weight}{Numeric constant, lower limit on the weight of the cliques to find.
\code{NULL} means no limit, i.e. it is the same as 0.}

\item{max.weight}{Numeric constant, upper limit on the weight of the cliques to find.
\code{NULL} means no limit.}

\item{maximal}{Specifies whether to look for all weighted cliques (\code{FALSE})
or only the maximal ones (\code{TRUE}).}
}
\value{
\code{weighted_cliques()} and \code{largest_weighted_cliques()} return a
list containing numeric vectors of vertex IDs. Each list element is a weighted
clique, i.e. a vertex sequence of class \code{\link[=V]{igraph.vs()}}.

\code{weighted_clique_num()} and \code{count_max_weighted_cliques} return an integer
scalar.
}
\description{
These functions find all, the largest or all the maximal weighted cliques in
an undirected graph. The weight of a clique is the sum of the weights of its
edges.
}
\details{
\code{weighted_cliques()} find all complete subgraphs in the input graph,
obeying the weight limitations given in the \code{min} and \code{max}
arguments.

\code{largest_weighted_cliques()} finds all largest weighted cliques in the
input graph. A clique is largest if there is no other clique whose total
weight is larger than the weight of this clique.

\code{max_weighted_cliques} finds all maximal weighted cliques in the input graph.
A weighted clique is maximal if it cannot be extended to a clique with larger
total weight. The largest weighted cliques are always maximal, but a maximal
weighted clique is not necessarily the largest.

\code{count_max_weighted_cliques} counts the maximal weighted cliques.

\code{weighted_clique_num()} calculates the weight of the largest weighted clique(s).
}
\examples{

g <- make_graph("zachary")
V(g)$weight <- 1
V(g)[c(1, 2, 3, 4, 14)]$weight <- 3
weighted_cliques(g)
weighted_cliques(g, maximal = TRUE)
largest_weighted_cliques(g)
weighted_clique_num(g)
}
\seealso{
\code{\link[=ivs]{ivs()}}

Other cliques: 
\code{\link{cliques}()},
\code{\link{ivs}()}
}
\author{
Tamas Nepusz \email{ntamas@gmail.com} and Gabor Csardi
\email{csardi.gabor@gmail.com}
}
\concept{cliques}
\keyword{graphs}
