% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/layout.R
\name{layout_with_mds}
\alias{layout.mds}
\alias{layout_with_mds}
\alias{with_mds}
\title{Graph layout by multidimensional scaling}
\usage{
layout_with_mds(graph, dist = NULL, dim = 2, options = arpack_defaults)

with_mds(...)
}
\arguments{
\item{graph}{The input graph.}

\item{dist}{The distance matrix for the multidimensional scaling.  If
\code{NULL} (the default), then the unweighted shortest path matrix is used.}

\item{dim}{\code{layout_with_mds} supports dimensions up to the number of nodes
minus one, but only if the graph is connected; for unconnected graphs, the
only possible values is 2. This is because \code{merge_coords} only works in
2D.}

\item{options}{This is currently ignored, as ARPACK is not used any more for
solving the eigenproblem}

\item{...}{Passed to \code{layout_with_mds}.}
}
\value{
A numeric matrix with \code{dim} columns.
}
\description{
Multidimensional scaling of some distance matrix defined on the vertices of
a graph.
}
\details{
\code{layout_with_mds} uses metric multidimensional scaling for generating the
coordinates. Multidimensional scaling aims to place points from a higher
dimensional space in a (typically) 2 dimensional plane, so that the distance
between the points are kept as much as this is possible.

By default igraph uses the shortest path matrix as the distances between the
nodes, but the user can override this via the \code{dist} argument.

This function generates the layout separately for each graph component and
then merges them via \code{\link{merge_coords}}.
}
\examples{
g <- sample_gnp(100, 2/100)
l <- layout_with_mds(g)
plot(g, layout=l, vertex.label=NA, vertex.size=3)
}
\author{
Tamas Nepusz \email{ntamas@gmail.com} and Gabor Csardi
\email{csardi.gabor@gmail.com}
}
\references{
Cox, T. F. and Cox, M. A. A. (2001) \emph{Multidimensional
Scaling}.  Second edition. Chapman and Hall.
}
\seealso{
\code{\link{layout}}, \code{\link{plot.igraph}}

Other graph layouts: \code{\link{add_layout_}};
  \code{\link{as_bipartite}},
  \code{\link{layout.bipartite}},
  \code{\link{layout_as_bipartite}}; \code{\link{as_star}},
  \code{\link{layout.star}}, \code{\link{layout_as_star}};
  \code{\link{as_tree}}, \code{\link{layout_as_tree}};
  \code{\link{component_wise}}; \code{\link{in_circle}},
  \code{\link{layout_in_circle}};
  \code{\link{layout.auto}}, \code{\link{layout_nicely}},
  \code{\link{nicely}};
  \code{\link{layout.davidson.harel}},
  \code{\link{layout_with_dh}}, \code{\link{with_dh}};
  \code{\link{layout.gem}}, \code{\link{layout_with_gem}},
  \code{\link{with_gem}}; \code{\link{layout.graphopt}},
  \code{\link{layout_with_graphopt}},
  \code{\link{with_graphopt}}; \code{\link{layout.grid}},
  \code{\link{layout.grid.3d}},
  \code{\link{layout.grid.3d}},
  \code{\link{layout_on_grid}}, \code{\link{on_grid}};
  \code{\link{layout.merge}},
  \code{\link{layout_components}},
  \code{\link{merge_coords}},
  \code{\link{piecewise.layout}},
  \code{\link{piecewise.layout}};
  \code{\link{layout.norm}}, \code{\link{norm_coords}};
  \code{\link{layout.sugiyama}},
  \code{\link{layout_with_sugiyama}},
  \code{\link{with_sugiyama}};
  \code{\link{layout_on_sphere}}, \code{\link{on_sphere}};
  \code{\link{layout_randomly}}, \code{\link{randomly}};
  \code{\link{layout_with_fr}}, \code{\link{with_fr}};
  \code{\link{layout_with_kk}}, \code{\link{with_kk}};
  \code{\link{layout_with_lgl}}, \code{\link{with_lgl}};
  \code{\link{layout}}, \code{\link{layout_}},
  \code{\link{print.igraph_layout_modifier}},
  \code{\link{print.igraph_layout_spec}};
  \code{\link{normalize}}
}
\keyword{graphs}

