% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mag.R
\name{mag}
\alias{mag}
\title{Calculate the Mean Absolute Glucose (MAG)}
\usage{
mag(data, n = 60, dt0 = NULL, inter_gap = 45, tz = "")
}
\arguments{
\item{data}{DataFrame object with column names "id", "time", and "gl".}

\item{n}{Integer giving the desired interval in minutes over which to calculate
the change in glucose. Default is 60 to have hourly (60 minutes) intervals.}

\item{dt0}{The time frequency for interpolation in minutes, the default will match the CGM meter's frequency (e.g. 5 min for Dexcom).}

\item{inter_gap}{The maximum allowable gap (in minutes) for interpolation. The values will not be interpolated between the glucose measurements that are more than inter_gap minutes apart. The default value is 45 min.}

\item{tz}{A character string specifying the time zone to be used. System-specific (see \code{\link{as.POSIXct}}), but " " is the current time zone, and "GMT" is UTC (Universal Time, Coordinated). Invalid values are most commonly treated as UTC, on some platforms with a warning.}
}
\value{
A tibble object with two columns: subject id and MAG value
}
\description{
The function mag calculates the mean absolute glucose or MAG.
}
\details{
A tibble object with a column for subject id and a column for MAG values is
returned.

The glucose values are linearly interpolated over a time grid starting at the
beginning of the first day of data and ending on the last day of data. Then, MAG
is calculated as \eqn{\frac{|\Delta BG|}{\Delta t}} where \eqn{|\Delta BG|} is
the sum of the absolute change in blood glucose calculated for each interval as specified
by n, default n = 60 for hourly change in blood glucose. The sum is then divided by
\eqn{\Delta t} which is the total time in hours.
}
\examples{

data(example_data_1_subject)
mag(example_data_1_subject)

data(example_data_5_subject)
mag(example_data_5_subject)

}
\references{
Hermanides et al. (2010) Glucose Variability is Associated with Intensive Care Unit
Mortaility,
\emph{Critical Care Medicine} \strong{38(3)} 838-842,
\doi{10.1097/CCM.0b013e3181cc4be9}
}
\author{
Elizabeth Chun
}
