\name{ppigt}

\alias{ppigt}

\title{probability versus probability plot for the the IGTD}

\description{
  The function \code{ppigt()} produces a probability-probability (pp) plot for the IGTD
  based on the MLE of their parameters. Also, a line going through the first and 
  the third quartile can be sketched. In addition, the coefficient of determination 
  of least squares for the fit line is given.
}

\usage{
ppigt(x, kernel = "normal", line = FALSE, 
      xLabel = "Empirical distribution function", 
      yLabel = "Theorical distribution function")
}

\arguments{
  \item{x}{Vector of observations.}
  \item{kernel}{Kernel of the pdf of the associated symmetrical distribution 
                by means of which the IGTD is obtained. The kernels: 
                \code{"laplace"}, \code{"logistic"}, \code{"normal"} and 
                \code{"t"} are available.}
  \item{line}{Logical; if TRUE (default), a line going by the first and third 
              quartile is sketched.}
  \item{xLabel}{A title for the x axis.}
  \item{yLabel}{A title for the x axis.}
}

\details{
  The function \code{ppigt()} carries out a pp plot for the IGTD.
}

\value{
 The function \code{ppigt()} carries out an graphical plot
 useful as goodness-of-fit tool.
}

\references{Sanhueza, A., Leiva, V., Balakrishnan, N. (2008). A new class of 
            inverse Gaussian type distributions. Metrika (in press).}

\author{
Vctor Leiva <victor.leiva@uv.cl; victor.leiva@yahoo.com>, \cr
Hugo Hernndez <hugo.hernandez.p@gmail.com> and \cr
Antonio Sanhueza <asanhueza@ufro.cl>.
}

\examples{
## Generates a sample from the IGTD with normal kernel
x <- rigt(300, mu = 1.0, lambda = 1.0, kernel = "normal")

## Produces a pp plot for the IGTD with normal kernel
ppigt(x, kernel = "normal", line = TRUE)
}

\keyword{univar}
\keyword{htest}


