% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Re.R
\encoding{UTF-8}
\name{Re2}
\alias{Re2}
\title{Calculating the Reynolds Number 2}
\usage{
Re2(D, V, nu)
}
\arguments{
\item{D}{numeric vector that contains the hydraulic diameters "(four times
the area in flow divided by the wetted surface) is a characteristic
length" (m or ft)  {Reference: Lindeburg Manual}}

\item{V}{numeric vector that contains the average fluid velocity (m/s or
ft/s)  {Reference: Lindeburg Manual}}

\item{nu}{numeric vector that contains the kinematic viscosity of the fluid
(m^2/s or lbf-sec/ft^2)  {Reference: Lindeburg Manual}}
}
\value{
the Reynolds number as a numeric \code{\link[base]{vector}} for Re2
}
\description{
Calculating the Reynolds Number 2
}
\examples{

# from Lindeburg Reference page 17-8
# where
# D = 0.3355 ft
# V = 7.56 ft/sec
# nu = 1.41 * 10 ^ -5 ft^2 / sec
# and
# Re = 1.8 * 10 ^ 5

library("iemisc")

Re2(D = 0.3355, V = 7.56, nu = 1.41 * 10 ^ -5)

# compare to Re1(D = 0.3355, V = 7.56, rho = 1.937, mu = 2.09 * 10 ^ -5, units = "slug")

Re2(D = 0.3355, V = 7.56, nu = 1.08 * 10 ^ -5)


}
\seealso{
\code{\link{Re1}} for the additional seealso, description, details, note, and references sections, \code{\link{Re3}}, \code{\link{Re4}}
}
\author{
Irucka Embry
}
