% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AgivenFcont.R
\encoding{UTF-8}
\name{FgivenPcont}
\alias{FgivenPcont}
\title{Future value given Present value [continuous] (Engineering Economics)}
\usage{
FgivenPcont(P, n, r)
}
\arguments{
\item{P}{numeric vector that contains the present value(s)}

\item{n}{numeric vector that contains the period value(s)}

\item{r}{numeric vector that contains the continuously compounded nominal
annual interest rate(s) as a percent}
}
\value{
FgivenPcont numeric vector that contains the future value(s)
   rounded to 2 decimal places
}
\description{
Compute F given P with interest compounded continuously
}
\details{
F is expressed as

	\deqn{F = Pe^{rn}}

\describe{
\item{\emph{F}}{the "future equivalent"}
\item{\emph{P}}{the "present equivalent"}
\item{\emph{r}}{the "nominal annual interest rate, compounded
    continuously"}
\item{\emph{n}}{the "number of periods (years)"}
}
}
\examples{

library("iemisc")

# Example 4-33 from the Reference text (page 170)
FgivenPcont(10000, 2, 5) # the interest rate is 5\%



}
\references{
William G. Sullivan, Elin M. Wicks, and C. Patrick Koelling, \emph{Engineering Economy}, Fourteenth Edition, Upper Saddle River, New Jersey: Pearson/Prentice Hall, 2009, page 169-170.
}
\author{
Irucka Embry
}
