% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engr_survey3.R
\encoding{UTF-8}
\name{engr_survey4}
\alias{engr_survey4}
\title{Calculate the Station Distance between Engineering Survey Points}
\source{
r - Insert a character at a specific location in a string - Stack Overflow answered and edited by Justin on Dec 13 2012. See \url{https://stackoverflow.com/questions/13863599/insert-a-character-at-a-specific-location-in-a-string}.
}
\usage{
engr_survey4(
  object,
  ds_station,
  station_distance = 100,
  units = c("foot", "survey_ft", "survey_mile", "mile", "meters", "kilometers")
)
}
\arguments{
\item{object}{numeric vector that contains the upstream length}

\item{ds_station}{character vector that contains the ending engineering
survey station value}

\item{station_distance}{numeric vector that contains the horizontal distance
between any 2 points along the survey, the default is 100 feet}

\item{units}{character vector that contains the system of units for the
\code{station_distance} (options are \code{foot}, \code{survey_ft}
(United States Customary System) [US survey foot], \code{meters} for
International System of Units meters, or \code{kilometers} for International System
of Units kilometers}
}
\value{
the final engineering survey position (ex. Sta. 5+55)
}
\description{
Takes engineering survey points in various units (foot, US survey foot,
meters, or kilometers) and determines the upstream station location.
}
\examples{

# Please refer to the iemisc: Engineering Survey Examples vignette for
# additional examples
 
library("iemisc")

# Example 1

# "Conversely, if you were asked at what station a manhole 555 ft upstream of
# Sta 0+00 is, your answer would be 0.00 sta + 555 ft / 100 ft/sta = 5.55 sta =
# Sta 5+55." Source: Reference 2

engr_survey4(555, "0+00", units = "foot")






}
\references{
\enumerate{
   \item udunits.dat, v 1.18 2006/09/20 18:59:18 steve Exp, \url{https://web.archive.org/web/20230202155021/https://www.unidata.ucar.edu/software/udunits/udunits-1/udunits.txt}. Retrieved thanks to the Internet Archive: Wayback Machine
   \item Engineer Boards: Transportation. "Stationing. Dumb question?" Question asked by By NIKE, August 31, 2013 and answered by ptatohed on September 1, 2013. See \url{https://engineerboards.com/threads/stationing-dumb-question.21935/}.
}
}
\author{
Irucka Embry
}
