% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rms.R
\encoding{UTF-8}
\name{rms}
\alias{rms}
\title{Root-mean-square}
\usage{
rms(x, na.rm = FALSE)
}
\arguments{
\item{x}{numeric vector that contains the sample data points.}

\item{na.rm}{logical vector that determines whether the missing values
should be removed or not.}
}
\value{
sample root-mean-square as a numeric vector. The default choice is that
  any NA values will be kept (\code{na.rm = FALSE}). This can be changed by
  specifying \code{na.rm = TRUE}, such as \code{rms(x, na.rm = TRUE)}.
}
\description{
This function computes the sample root-mean-square (RMS).
}
\details{
RMS is expressed as

\deqn{x_{rms} = \sqrt{\frac{\sum \limits_{i=1}^n{x_{i}^{2}}}{n}}}

\describe{
\item{\emph{\eqn{x_rms}}}{the sample harmonic mean}
\item{\emph{x}}{the values in a sample}
\item{\emph{n}}{the number of values}
}
}
\examples{
library(iemisc)
samp <- c(0.5, 100, 1000.25, 345, 0.0213, 0, 45, 99, 23, 11, 1, 89, 0, 34,
        65, 98, 3)
rms(samp)

}
\references{
Masoud Olia, Ph.D., P.E. and Contributing Authors, \emph{Barron’s FE (Fundamentals of Engineering Exam)}, 3rd Edition, Hauppauge, New York: Barron’s Educational Series, Inc., 2015, page 84.
}
\seealso{
\code{\link{sgm}} for geometric mean, \code{\link{shm}} for harmonic mean, \code{\link{cv}}
 for coefficient of variation (CV), \code{\link{relerror}} for relative error,
 \code{\link{approxerror}} for approximate error, and \code{\link{ranges}} for sample range.
}
