% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ngq_alters}
\alias{ngq_alters}
\title{Ego Networks Elicited from the "Important Matters" Name Generator Question (Alter List)}
\format{
A data frame with 67 rows and 14 columns:
\describe{
  \item{ego_id}{Unique identifier for ego providing network}
  \item{alter_id}{Within-network unique identifier for person nominated by ego (alter).}
  \item{sex}{A numeric indicating alter's sex as reported by ego. \code{1} indicates male, \code{2} female.}
  \item{race}{A character indicating a simplified characterization of alter's race/ethnicity as reported by ego. Values include \code{"White"}, \code{"Black"}, and \code{"Other"}.}
  \item{black}{A logical indicating ego's perception of alter as "Black" or "African-American."}
  \item{white}{A logical indicating ego's perception of alter as "White."}
  \item{other_race}{A logical indicating ego's perception of alter as belonging to a racial/ethnic group other than "Black," "African-American," or "White."}
  \item{pol}{A numeric indicating political orientation on a seven-point scale, as perceived by ego. \code{1} indicates "Extremely Liberal," \code{4} "Moderate," and \code{7} "Extremely Conservative."}
  \item{family}{A logical indicating alter as ego's family member.}
  \item{friend}{A logical indicating alter as ego's friend.}
  \item{other_rel}{A logical indicating alter as have a relationship to ego other than one of the types of relationships listed above.}
  \item{face}{A numeric indicating how frequently ego and alter interact in person. \code{1} indicates "Never," \code{2} "Less than once a month," \code{3} "1-3 times a month," \code{4} "1-3 times a week," \code{5} "Daily or almost daily."}
  \item{phone}{A numeric indicating how frequently ego and alter talk on the phone or via video chat. \code{1} indicates "Never," \code{2} "Less than once a month," \code{3} "1-3 times a month," \code{4} "1-3 times a week," \code{5} "Daily or almost daily."}
  \item{text}{A numeric indicating how frequently ego and alter interact via electronic messaging (e.g. texting, email, social media). \code{1} indicates "Never," \code{2} "Less than once a month," \code{3} "1-3 times a month," \code{4} "1-3 times a week," \code{5} "Daily or almost daily."}
  ...
}
}
\source{
Original Data, Collected by Danielle Montagne, Joseph Quinn, Liann Tucker, and Tom Wolff.
}
\usage{
ngq_alters
}
\description{
This dataset contains a simplifed subset of 20 ego networks elicited using the "important matters" name generator question (NGQ),
which is frequently used to capture an individual's close personal ties. These networks were collected as part
of an experiment illustrating how networks generated by this question may vary depending on the topics covered in
preceding survey items. Networks were collected using an online survey deployed via Amazon Mechanical Turk.
}
\keyword{datasets}
