% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/krippalpha.R
\name{krippalpha}
\alias{krippalpha}
\title{Krippendorff's alpha}
\usage{
krippalpha(data, metric = "nominal", bootstrap = FALSE, bootnp = FALSE,
  nboot = 20000, nnp = 1000, cores = 1, custom_seed = NULL)
}
\arguments{
\item{data}{a matrix of reliability data.}

\item{metric}{metric difference function to be applied to disagreements. Supports \code{nominal}, \code{ordinal}, \code{interval}, and \code{ratio}. Defaults to \code{nominal}.}

\item{bootstrap}{logical indicating whether uncertainty estimates should be obtained using the bootstrap algorithm defined by Krippendorff. Defaults to \code{FALSE}.}

\item{bootnp}{logical indicating whether non-parametric bootstrap uncertainty estimates should be computed. Defaults to \code{FALSE}.}

\item{nboot}{number of bootstraps used in Krippendorff's algorithm. Defaults to \code{20000}.}

\item{nnp}{number of non-parametric bootstraps. Defaults to \code{1000}.}

\item{cores}{number of cores across which bootstrap-computations are distributed. Defaults to 1. If more cores are specified than available, the number will be set to the maximum number of available cores.}

\item{custom_seed}{numeric vector of length 6 for the internal L'Ecuyer-CMRG random number generator (see details). Defaults to \code{NULL}. When set to NULL, relies on R's \code{.Random.seed} vector.}
}
\value{
Returns a list of type \code{icr} with following elements:
\item{alpha}{value of inter-coder reliability coefficient}
\item{method}{data level of x}
\item{n_coders}{number of coders}
\item{n_units}{number of units to be coded}
\item{n_values}{number of unique values in reliability data}
\item{coincidence_matrix}{matrix containing coincidences within coder-value pairs}
\item{delta_matrix}{matrix of metric differences depending on \code{method}}
\item{D_e}{expected disagreement}
\item{D_o}{observed disagreement}
\item{bootstrap}{\code{TRUE} if Krippendorff bootstrapping algorithm was run, \code{FALSE} otherwise}
\item{nboot}{number of bootstraps}
\item{bootnp}{\code{TRUE} if nonparametric bootstrap was run, \code{FALSE} otherwise}
\item{nnp}{number of non-parametric bootstraps}
\item{bootstraps}{vector of bootstrapped values of alpha (Krippendorff's algorithm)}
\item{bootstrapsNP}{vector of non-parametrically bootstrapped values of alpha}
}
\description{
\code{krippalpha} computes Krippendorff's reliability coefficient alpha.
}
\details{
For proper seeding of \code{krippalpha}'s bootstrap-routines via R, specify \code{set.seed(seed, kind = "L'Ecuyer-CMRG")}. The seeds returned from R in \code{.Random.seed} are internally regarded as 32-bit unsigned integers (see \link{Random}), yet represented as 32-bit signed integers. \code{krippalpha} will hence convert the seed values obtained via \code{set.seed} and user-provided \code{custom_seed}s to unsigned 32-bit integers.

Please note that \code{krippalpha} takes the seed vector to seed the internal random number generator of both bootstrap-routines. Furthermore, it does not advance R's RNG state. \code{.Random.seed} will therefore be the same after \code{krippalpha} has been run.
}
\note{
\code{krippalpha}'s bootstrap-routines use L'Ecuyer's CMRG random number generator (see L'Ecyuer et al. 2002) to create random numbers suitable for parallel computations. The routines interface to L'Ecuyer's C++ code, which can be found at \url{https://pubsonline.informs.org/doi/abs/10.1287/opre.50.6.1073.358}
}
\examples{
data(codings)
krippalpha(codings)

set.seed(100, kind = "L'Ecuyer-CMRG")
krippalpha(codings, metric = "nominal", bootstrap = TRUE, bootnp = TRUE)

}
\references{
Krippendorff, K. (2004) \emph{Content Analysis: An Introduction to Its Methodology}. Beverly Hills: Sage.

Krippendorff, K. (2011) \emph{Computing Krippendorff's Alpha Reliability}. Departmental Papers (ASC) 43. \url{http://repository.upenn.edu/asc_papers/43}.

Krippendorff, K. (2016) \emph{Bootstrapping Distributions for Krippendorff's Alpha}. \url{http://web.asc.upenn.edu/usr/krippendorff/boot.c-Alpha.pdf}.

L'Ecuyer, P. (1999) Good Parameter Sets for Combined Multiple Recursive Random Number Generators. \emph{Operations Research}, 47 (1), 159--164. \url{https://pubsonline.informs.org/doi/10.1287/opre.47.1.159}.

L'Ecuyer, P., Simard, R, Chen, E. J., and Kelton, W. D. (2002) An Objected-Oriented Random-Number Package with Many Long Streams and Substreams. \emph{Operations Research}, 50 (6), 1073--1075. \url{http://www.iro.umontreal.ca/~lecuyer/myftp/streams00/c++/streams4.pdf}.
}
