% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transprob_msm.R, R/transprob_npmsm.R
\name{transprob.msm}
\alias{transprob.msm}
\alias{transprob.npmsm}
\alias{transprob.msfit}
\alias{transprob}
\title{Wrapper for the \code{\link[mstate:probtrans]{probtrans}} function}
\usage{
\method{transprob}{msm}(object, predt, times, ...)

\method{transprob}{npmsm}(object, ...)

\method{transprob}{msfit}(object, ...)

transprob(object, ...)
}
\arguments{
\item{object}{Object of compatible class}

\item{predt}{A positive number indicating the prediction time. This is 
 the time at which the prediction is made. If missing, smallest time of 
\code{times} is chosen.}

\item{times}{A vector of times at which the transition probabilities should 
be determined.}

\item{...}{Further arguments to \code{\link[mstate:probtrans]{probtrans}}}
}
\value{
A \code{probtrans} object containing the estimated transition probabilities.
}
\description{
For \code{'msm'} objects: determine transition probabilities
(as in \code{\link[mstate:probtrans]{probtrans}})  from an 
\code{\link[msm:msm]{msm}} object. Currently only direction = "forward" is supported.

For \code{'npmsm'} objects: Determine transition probabilities for an \code{'npmsm'} object 
using the \code{\link[mstate:probtrans]{probtrans}} function.

For \code{'msfit'} objects: Wrapper for \code{\link[mstate:probtrans]{probtrans}}
}
\details{
Can be used for objects of class 'npmsm', 'msm' and 'msfit'
}
