% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oanda.R
\name{oanda_quote}
\alias{oanda_quote}
\title{OANDA Quote Latest Price}
\usage{
oanda_quote(instrument, price = c("M", "B", "A"), server, apikey)
}
\arguments{
\item{instrument}{string containing the base currency and quote currency
delimited by '_' or '-' (e.g. "USD_JPY" or "usd-jpy"). Use the
\code{\link{oanda_instruments}} function to return a list of all valid
instruments.}

\item{price}{[default "M"] pricing component, one of "M" (midpoint), "B" (bid)
or "A" (ask).}

\item{server}{(optional) specify the "practice" or "live" server according to
the account type held. If not specified, will default to "practice", unless
this has been changed by \code{\link{oanda_switch}}.}

\item{apikey}{(optional) string containing the OANDA fxTrade API key (personal
access token), or function that returns this string. Does not need to be
specified if already stored by oanda_set_key(). Can also be entered
interactively if not specified.}
}
\value{
Invisible NULL. The instrument, timestamp, daily open, high, low and
    last prices, percentage change from the open, and the pricing component
    (M for mid, B for bid, A for ask) is output to the console.
}
\description{
Provides a single line price quote for an instrument.
}
\details{
This function is designed for interactive use.

    For further details please refer to the OANDA fxTrade API vignette by
    running: \code{vignette("xoanda", package = "ichimoku")}.
}
\examples{
\dontrun{
# OANDA fxTrade API key required to run this example
oanda_quote("USD_JPY")
}

}
