% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oanda.R
\name{oandaAccount}
\alias{oandaAccount}
\title{Account associated with an OANDA fxTrade API Key}
\usage{
oandaAccount(server = c("practice", "live"), apikey)
}
\arguments{
\item{server}{[default "practice"] select either the "practice" or "live" server
depending on the account type held with OANDA.}

\item{apikey}{(optional) string containing the OANDA fxTrade API key (personal
access token), or function that returns this string. Does not need to be
specified if already stored by oanda_set_key(). Can also be entered
interactively if not specified.}
}
\value{
A character string of the first listed account the authorization
    bearer token is authorized to access.
}
\description{
Return an account authorised to be accessed by an OANDA fxTrade API key
    (personal access token). Used by other OANDA functions to access API
    endpoints that require an account ID.
}
\keyword{internal}
