% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ichimoku.R
\name{ichimoku}
\alias{ichimoku}
\alias{ichimoku.ichimoku}
\alias{ichimoku.xts}
\alias{ichimoku.matrix}
\alias{ichimoku.data.frame}
\alias{ichimoku.default}
\title{ichimoku}
\usage{
ichimoku(x, ...)

\method{ichimoku}{ichimoku}(x, ticker, periods = c(9, 26, 52), ...)

\method{ichimoku}{xts}(x, ticker, periods = c(9, 26, 52), ...)

\method{ichimoku}{matrix}(x, ticker, periods = c(9, 26, 52), ...)

\method{ichimoku}{data.frame}(x, ticker, periods = c(9, 26, 52), ...)

\method{ichimoku}{default}(x = NULL, ticker, periods = c(9, 26, 52), ...)
}
\arguments{
\item{x}{a data.frame or other compatible object, which includes xts,
data.table, tibble, and matrix.}

\item{...}{other arguments to be passed along. For instance, 'holidays' may
be passed to the \code{\link{tradingDays}} function, used by ichimoku when
calculating the future cloud.}

\item{ticker}{(optional) specify a ticker to identify the instrument,
otherwise this is set to the name of the input object 'x'.}

\item{periods}{a vector defining the length of periods used for the cloud,
with a default of c(9, 26, 52). This parameter shoud not normally be
changed as using other values would be invalid in the context of
traditional Ichimoku analysis.}
}
\value{
An ichimoku object is returned with S3 classes of 'ichimoku', 'xts'
    and 'zoo'.

    This object contains a date-time index, OHLC pricing data, candle
    direction, the computed ichimoku cloud values, and cloud top and base
    values, with ticker, periods, and periodicity parameters set as
    attributes.
}
\description{
Create an ichimoku object containing the values for all components of the
    Ichimoku Kinko Hyo cloud chart, ready for plotting. The object includes
    a date-time index, OHLC pricing data, candle direction, the cloud lines
    Tenkan-sen, Kijun-sen, Senkou span A, Senkou span B and Chikou span, as
    well as values for the cloud top and base.
}
\details{
Calling an ichimoku object automatically invokes its print method,
    which will by default produce a printout of the data to the console as
    well as a static plot of the cloud chart to the graphical device.

    For further options, including interactive charting, use plot() on the
    returned ichimoku object to pass further arguments for customising
    the chart.

    Where an ichimoku object is passed to ichimoku(), the ichimoku object is
    re-calculated using the OHLC pricing data contained within.
}
\section{Further Details}{

    Please refer to the reference vignette by running:
    \code{vignette("reference", package = "ichimoku")}
}

\examples{
cloud <- ichimoku(sample_ohlc_data)
ichimoku(sample_ohlc_data, ticker = "TKR", periods = c(9, 26, 52))

}
