% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vocab_get.R
\name{vocab_get}
\alias{vocab_get}
\alias{vocab_get_cached}
\title{Get a url}
\usage{
vocab_get(
  url,
  retry = TRUE,
  quiet = !getOption("icesVocab.messages"),
  verbose = FALSE,
  content = TRUE
)

vocab_get_cached(
  url,
  retry = TRUE,
  quiet = !getOption("icesVocab.messages"),
  verbose = FALSE,
  content = TRUE
)
}
\arguments{
\item{url}{the url to get.}

\item{retry}{should the get request be retried if first attempt
fails? default TRUE.}

\item{quiet}{should all messages be suppressed, default FALSE.}

\item{verbose}{should verbose output form the http request be
returned? default FALSE.}

\item{content}{should content be returned, or the full http response?
default TRUE, i.e. content is returned by default.}
}
\value{
content or an http response.
}
\description{
Get a url, optionally using an ICES authentication token
}
\section{Functions}{
\itemize{
\item \code{vocab_get_cached()}: cached version of vocab_get

}}
\examples{
\dontrun{
vocab_get(vocab_api("StockList", year = 2022))
}
}
\seealso{
\code{\link{vocab_api}} builds a SAG web service url.

\code{\link{icesVocab-package}} gives an overview of the package.
}
