% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnd.R
\name{rnd}
\alias{rnd}
\title{Round Columns}
\usage{
rnd(x, cols, digits = 0)
}
\arguments{
\item{x}{a data frame.}

\item{cols}{column names.}

\item{digits}{number of decimal places.}
}
\value{
A data frame similar to \code{x}, after rounding columns \code{cols} to the
number of \code{digits}.
}
\description{
Round column values in a data frame.
}
\note{
Provides notation that is reliable and convenient for modifying a large
number of columns, not repeating column names twice.
}
\examples{
summary <- rnd(summary.taf, c("Fbar", "Fbar_lo", "Fbar_hi"), 2)

}
\seealso{
\code{\link{round}} is the underlying function used to round numbers.

\code{\link{div}} is a similar function to divide columns with a common
number.

\code{\link{icesTAF-package}} gives an overview of the package.

The \pkg{icesAdvice} package provides the \code{\link[icesAdvice]{icesRound}}
function to round values for ICES advice sheets.
}
