% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icd9SubsequentMinors}
\alias{icd9PrecedingMinors}
\alias{icd9SubsequentMinors}
\title{determine preceding or subsequent post-decimal parts of ICD9 codes}
\usage{
icd9SubsequentMinors(minor, isE)

icd9PrecedingMinors(minor, isE)
}
\arguments{
\item{minor}{character vector of 'minor' part of ICD-9 codes, i.e. that part
which falls after the decimal point, in decimal notation. (In 5 digit
notation, the 'major' part is be xyz, even when x and y are zero, thus the
last two characters represent the 'minor' part, in this case.)}
}
\description{
this is not simply numeric, since "4" is after "39" and "0" !=
  "00". Frustrating to have to do so much string manipulation, but, as I have
  learned, it is not possible to treat ICD-9 codes as numbers without risking
  ambiguity and subtle mistakes.
}
\seealso{
Other ICD-9 ranges: \code{\link{\%i9d\%}},
  \code{\link{icd9ExpandRangeDecimal}};
  \code{\link{\%i9mj\%}},
  \code{\link{icd9ExpandRangeMajor}};
  \code{\link{\%i9s\%}},
  \code{\link{icd9ExpandRangeShort}};
  \code{\link{icd9ChildrenDecimal}};
  \code{\link{icd9Children}},
  \code{\link{icd9ChildrenShort}};
  \code{\link{icd9CondenseToExplain}};
  \code{\link{icd9CondenseToMajor}};
  \code{\link{icd9ExpandMinor}},
  \code{\link{icd9ExpandMinorE}},
  \code{\link{icd9ExpandMinorNV}}
}
\keyword{internal}
\keyword{manip}

