% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icd9ShortToDecimal}
\alias{icd9ShortToDecimal}
\title{icd9ShortToDecimal}
\usage{
icd9ShortToDecimal(icd9Short, leadingZeroes = F, keepLoneDecimal = F,
  validate = F)
}
\arguments{
\item{icd9Short}{is a character vector of ICD-9 codes. If fewer than five characters is given
in a code, then the digits are greedily assigned to hundreds, then tens,
then units, before the decimal parts. E.g. "10" becomes "010", not "0010"}

\item{leadingZeroes}{logical whether to fill out major part with zeroes, or
just truncate to the left. If E code, there is no valid code since
E800-E999 is defined. V codes could be V0x or Vxx, and so could be zero
padded.}

\item{keepLoneDecimal}{logical. Since the presence or absence of a trailing
zero in an ICD-9 code can make a difference, when converting to decimal, we
have a situation where we do not want to add trailing zeroes, but may wish
to preserve the decimal point. If this is desired, then set this value to
TRUE.}

\item{validate}{logical whether to validate the input ICD-9 codes for
correctness. There may be additional simple checks, e.g. whether the code
is of the right type, regardless of this argument.}
}
\description{
converts ICD-9 'short' form to decimal form
}
\keyword{manip}

