% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse.R
\name{parse_leaf_descriptions_all}
\alias{parse_leaf_descriptions_all}
\title{Get billable codes from all available years}
\source{
http://www.cms.gov/Medicare/Coding/ICD9ProviderDiagnosticCodes/codes.html
}
\usage{
parse_leaf_descriptions_all(save_data = TRUE, offline = TRUE)
}
\arguments{
\item{save_data}{single logical value, if \code{TRUE} the source text or CSV
file will be saved in \code{data-raw}, otherwise (the default) the data is
simply returned invisibly.}

\item{offline}{single logical, if \code{TRUE} then don't pull the file from
internet, only return path and file name if the file already exists in
data-raw. This is helpful for testing without using the internet.}
}
\value{
data frame with \code{icd9}, \code{short_desc} and \code{long_desc} columns. \code{NA} is placed
  in \code{long_desc} when not available.
}
\description{
For versions 23 to 32, those which are on the CMS web site, get
  any codes with long or short descriptions. Earlier years only have
  abbreviated descriptions.
}
\examples{
  # To populate the data-raw directory with the ICD-9 source:
  # not included in installed package, run using the full source from github,
  # e.g. using devtools::load_all()
  \dontrun{
  parse_leaf_descriptions_all(save_data = TRUE, offline = TRUE)
  }
}
\keyword{internal}

