% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse-rtf.R
\name{fix_unicode}
\alias{fix_unicode}
\title{Fix Unicode characters in RTF}
\usage{
fix_unicode(filtered, perl = TRUE, useBytes = TRUE)
}
\description{
fix ASCII, Code Page 1252 and Unicode horror: some character definitions are
split over lines... This needs care in Windows, or course. Maybe Mac, too?
}
\details{
First: c cedilla, e grave, e acute Then:  n tilde, o umlaut
}
\examples{
\dontrun{
# fix_unicode is a slow step, useBytes and perl together is faster
f_info_rtf <- fetch_rtf_year("2011", offline = FALSE)
rtf_lines <- readLines(f_info_rtf$file_path, warn = FALSE, encoding = "ASCII")
microbenchmark::microbenchmark(
  res_both <- fix_unicode(rtf_lines, perl = TRUE, useBytes = TRUE),
  res_none <- fix_unicode(rtf_lines, perl = FALSE, useBytes = FALSE),
  res_bytes <- fix_unicode(rtf_lines, perl = FALSE, useBytes = TRUE),
  res_perl <- fix_unicode(rtf_lines, perl = TRUE, useBytes = FALSE),
  times = 5
)
stopifnot(identical(res_both, res_none))
}
}
\keyword{internal}
\keyword{manip}

