% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_intervals.R
\name{form_class_intervals}
\alias{form_class_intervals}
\title{Form Class Intervals}
\usage{
form_class_intervals(
  .data,
  variable,
  method = c("equal", "width", "count", "manual"),
  n_intervals = 4L,
  interval_width,
  format = "(a,b]",
  range = NULL,
  format.lowest = ifelse(isinteger, "< a", "<= a"),
  format.highest = "> b",
  break_points = NULL,
  name = sprintf("\%s.f", variable)
)
}
\arguments{
\item{.data}{the data set}

\item{variable}{name of the variable to convert}

\item{method}{one of 'equal' for equal-width interavls, 'width' for intervals of a specific width, 'count' for equal-count intervals, and 'manual' to specify break points manually}

\item{n_intervals}{for methods 'equal' and 'count', this is the number of intervals to create}

\item{interval_width}{for method 'width', this is the width of intervals}

\item{format}{the format for intervals; use 'a' and 'b' to represent the min/max of each interval, respectively.}

\item{range}{the range of the data; use this to adjust the labels (e.g., for continuous data, set this to floor/ceiling of the min/max of the data to get prettier intervals). If \code{range} does not cover the range of the data, values outside will be placed into 'less than a' and 'greater than b' categories}

\item{format.lowest}{values lower than the min of \code{range} will have this label format}

\item{format.highest}{values higher than the max of \code{range} will have this label format}

\item{break_points}{for \code{method} 'manual', specify breakpoints here (as a numeric vector)}

\item{name}{the name of the new variable in the resulting data set}
}
\value{
a dataframe with an additional column with categorical class intervals
}
\description{
Create categorical intervals from a numeric variable.
}
\examples{
form_class_intervals(iris, 'Sepal.Length', 'equal', 5L)
}
\author{
Tom Elliott
}
