% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareplot.R
\name{plot.iNZightMTS}
\alias{plot.iNZightMTS}
\title{Plot multiple time series}
\usage{
\method{plot}{iNZightMTS}(
  x,
  compare = TRUE,
  multiplicative = FALSE,
  ylab = "Value",
  xlab = "Date",
  title = "\%var",
  t = 10,
  smoother = TRUE,
  aspect = 2,
  xlim = c(NA, NA),
  model.lim = NULL,
  ...
)
}
\arguments{
\item{x}{Multiple time series object}

\item{compare}{logical, if \code{true}, the series will be graphed in a single plot;
otherwise graphed in individual rows}

\item{multiplicative}{logical, if TRUE multiplicative series will be used; otherwise additive}

\item{ylab}{y axis label}

\item{xlab}{x axis label}

\item{title}{the title for the plot}

\item{t}{smoothing parameter}

\item{smoother}{logical, if \code{TRUE} the smoother will be drawn}

\item{aspect}{aspect ratio (width:height) for the time series}

\item{xlim}{limits to control how much of series is shown}

\item{model.lim}{time limits to use for modelling}

\item{...}{additional arguments}
}
\value{
No return value, called for the side effect of drawing a plot.
}
\description{
Plot a multiple time series object to compare several series
}
\examples{
tm <- iNZightTS(visitorsQ, var = 2:5)
plot(tm)
plot(tm, compare = FALSE)

}
\author{
Tom Elliott
}
