% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{CIARforecast}
\alias{CIARforecast}
\title{Forecast from CIAR model}
\usage{
CIARforecast(phiR, phiI, y1, st, tAhead)
}
\arguments{
\item{phiR}{Real part of the phi coefficient of CIAR model.}

\item{phiI}{Imaginary part of the phi coefficient of CIAR model.}

\item{y1}{Array with the time series observations.}

\item{st}{Array with the observational times.}

\item{tAhead}{The time ahead for which the forecast is required.}
}
\value{
A list with the following components:
\itemize{
\item{fitted}{ Fitted values by the CIAR model.}
\item{forecast}{ Point forecast in the time ahead required.}
\item{Lambda}{ Lambda value estimated by the CIAR model at the last time point.}
\item{Sighat}{ Covariance matrix estimated by the CIAR model at the last time point.}
}
}
\description{
Forecast from models fitted by \code{\link{CIARkalman}}
}
\examples{
#Simulated Data
n=100
set.seed(6714)
st<-gentime(n)
x=CIARsample(n=n,phiR=0.9,phiI=0,st=st,c=1)
y=x$y
y1=y/sd(y)
n=length(y1)
p=trunc(n*0.99)
ytr=y1[1:p]
yte=y1[(p+1):n]
str=st[1:p]
ste=st[(p+1):n]
tahead=ste-str[p]

ciar=CIARkalman(y=ytr,t=str)
forCIAR<-CIARforecast(ciar$phiR,ciar$phiI,ytr,str,tAhead=tahead)
}
\references{
\insertRef{Elorrieta_2019}{iAR}
}
\seealso{
\code{\link{CIARsample}}, \code{\link{CIARkalman}}, \code{\link{CIARfit}}
}
