% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IARphiloglik.R
\name{IAR.phi.loglik}
\alias{IAR.phi.loglik}
\title{Minus Log Likelihood of the IAR Model}
\usage{
IAR.phi.loglik(
  x,
  y,
  sT,
  delta = 0,
  include.mean = "FALSE",
  standarized = "TRUE"
)
}
\arguments{
\item{x}{A given phi coefficient of the IAR model.}

\item{y}{Array with the time series observations.}

\item{sT}{Array with the irregular observational times.}

\item{delta}{Array with the measurements error standard deviations.}

\item{include.mean}{logical; if true, the array y has zero mean; if false, y has a mean different from zero.}

\item{standarized}{logical; if true, the array y was standarized; if false, y contains the raw data}
}
\value{
Value of the negative log likelihood evaluated in phi.
}
\description{
This function return the negative log likelihood of the IAR Model for a specific value of phi.
}
\examples{

set.seed(6714)
st<-gentime(n=100)
y<-IAR.sample(phi=0.99,n=100,st)
y<-y$series
IAR.phi.loglik(x=0.8,y=y,sT=st)
}
\references{
\insertRef{Eyheramendy_2018}{iAR}
}
\seealso{
\code{\link{gentime}}, \code{\link{IAR.sample}}
}
