% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.spe.R
\name{read.spe}
\alias{read.spe}
\alias{read.spe.header}
\alias{spe.showcalpoints}
\title{Import WinSpec SPE file}
\usage{
read.spe(filename, xaxis = "file", acc2avg = F, cts_sec = F,
  keys.hdr2data = c("exposure_sec", "LaserWavelen", "accumulCount",
  "numFrames", "darkSubtracted"))

read.spe.header(filename)

spe.showcalpoints(filename, xaxis = "file", acc2avg = F, cts_sec = F)
}
\arguments{
\item{filename}{Name of the SPE file to read data from}

\item{xaxis}{Units of x-axis, e.g. \emph{"file"}, \emph{"px"},
\emph{"nm"}, \emph{"energy"}, \emph{"raman"}, \emph{...}
\code{read.spe} function automatically checks if the x-calibration data are
available and uses them (if possible) to reconstruct the xaxis
in the selected units.}

\item{acc2avg}{whether to divide the actual data set by the number of
accumulations, thus transforming \emph{accumulated} spectra to
\emph{averaged} spectra. WinSpec does not do this automatically, so the
spectral intensity is always proportional to the number of accumulations.
The flag \code{@data$averaged} is automatically set to \code{TRUE}.}

\item{cts_sec}{whether to divide the actual data set by the exposure time,
thus going to count per second unit.}

\item{keys.hdr2data}{Which metadata from the file header should be saved to
the \code{Data} slot of a newly created hyperSpec object}
}
\value{
hyperSpec object

hdr list with \code{key=value} pairs
}
\description{
Import function for WinSpec SPE files (file version up to 3.0). The calibration
data (polynome and calibration data pairs) for x-axis are automatically
read and applied to the spectra. Note that the y-calibration data structure
is not extracted from the file since it is not saved there by WinSpec and is
always empty.
}
\section{Functions}{
\itemize{
\item \code{read.spe.header}: Read only header of a WinSpec SPE file (version 2.5)

\item \code{spe.showcalpoints}: Plot the WinSpec SPE file (version 2.5) and show the
calibration points stored inside of it (x-axis calibration)
}}

\author{
R. Kiselev, C. Beleites
}
