% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ff_read_snih.R
\name{read_snih}
\alias{read_snih}
\title{Reads data from Servicio Nacional de Información Hídrica \href{https://back.argentina.gob.ar/obras-publicas/hidricas/base-de-datos-hidrologica-integrada}{(SNIH - Argentina)}}
\usage{
read_snih(path, by, out_name = NULL)
}
\arguments{
\item{path}{path to the xlsx file.}

\item{by}{string with the time step of the series (e.g.: \code{'month', 'day', '6 hour',
'3 hour', '1 hour', '15 min' }). If you set it as \code{'none'}, the function will
ignore automatic gap filling.}

\item{out_name}{optional. String vector with user defined variable(s) column(s) name(s).}
}
\value{
A data frame with the data inside the xlsx file. Gaps between dates are
filled with \code{NA_real_} and duplicated rows are eliminated automatically.
}
\description{
Reads excel files downloaded from the SNIH web page as a data frame.
}
\examples{

# set path to file
path_file <- system.file('extdata', 'snih_qd_guido.xlsx', package = 'hydrotoolbox')

# read daily streamflow with default column name
head( read_snih(path = path_file, by = 'day') )

# now we use the function with column name
head( read_snih(path = path_file,  by = 'day', out_name = 'qd(m3/s)') )


}
