% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydro_coords.R
\name{hydro_coords}
\alias{hydro_coords}
\title{Convert coordinates from Hydroscope's points to a tibble}
\usage{
hydro_coords(x)
}
\arguments{
\item{x}{a string vector with the points retrieved from Hydroscope}
}
\value{
a tibble with the longitude and latitude values.
}
\description{
\code{hydro_coords} returns a tibble with the stations'
longitude and latitude using as input the variable \code{point}
from \code{get_stations} function.
}
\examples{
\dontrun{
# get stations from the Greek Ministry of Environment and Energy
kyy_stations <-get_stations("kyy")

# create a tibble with stations' coords
coords <- hydro_coords(kyy_stations$point)
}
}
\author{
Konstantinos Vantas, \email{kon.vantas@gmail.com}
}
