% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_path_helpers.R
\name{cache_set_dir}
\alias{cache_set_dir}
\title{Set local cache path}
\usage{
cache_set_dir(path = NULL, temppath = FALSE)
}
\arguments{
\item{path}{Character path to new local files path. If null, path will be
reset to default user data directory location.}

\item{temppath}{Boolean flag indicating if the default R temp directory should
be used instead of a custom or user-workspace area. Warning:
This setting will not persist between R sessions and the
temp directory is cleared when R is closed. Using temp will result
in frequent file downloads and extremely slow performance}
}
\description{
Set location of local data file cache. If the directory does not exist, it
will be created recursively. If no custom path is set, the
default user data directory for the package will be used. See
\code{\link[rappdirs]{user_data_dir}} for details.
}
\examples{
\dontrun{
  #set a different cache path
  set_cache_path('z:/big_datasets/hydrolinks')
}

}
\seealso{
\code{\link{cache_get_dir}}
}
