% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\docType{methods}
\name{A1}
\alias{A1}
\alias{A1,ChipInfo-method}
\alias{A2}
\alias{A2,ChipInfo-method}
\alias{A1<-}
\alias{A1<-,ChipInfo-method}
\alias{A2<-}
\alias{A2<-,ChipInfo-method}
\title{Access alleles for ChipInfo}
\usage{
A1(x)

\S4method{A1}{ChipInfo}(x)

A2(x)

\S4method{A2}{ChipInfo}(x)

A1(x) <- value

\S4method{A1}{ChipInfo}(x) <- value

A2(x) <- value

\S4method{A2}{ChipInfo}(x) <- value
}
\arguments{
\item{x}{a ChipInfo object}

\item{value}{new allele codes, e.g, A,C,G,T}
}
\value{
character vector of allele codes (or NAs)

A1<-: updates the ChipInfo object specified with new allele codes for the 'A1' slot

A2<-: updates the ChipInfo object specified with new allele codes for the 'A2' slot
}
\description{
A1/A2: Returns the letter for the A1/A2 alleles for the chip object, 
e.g, 'A','C','G','T', etc
Only if these are annotated internally, or else a vector of NAs

A1<-/A2<-: Allows user to set the allele codes for each SNP of the chip object, 
e.g, A,C,G,T,K, etc. If you are using allele codes this is likely to 
necessary as each genotyping produces a different set of allele codes.
If using in conjunction with snpStats, remember that allele codes are
always flipped to be alphabetical, so the reference allele is the later
letter in the alphabet. Note, assignment to A2 needs to be done separately.
}
