\name{huge.GECT}
\alias{huge.GECT}

\title{
Graph Estimation via Correlation Thresholding (GECT)
}

\description{
Implements Graph Estimation via Correlation Thresholding (GECT) which approximates the graph by thresholding sample correlations.
}

\usage{
huge.GECT(x, nlambda = NULL, lambda.min.ratio = NULL, lambda = NULL, verbose = TRUE)
}

\arguments{
  \item{x}{
There are 2 options for the input:(1) The \code{n} by \code{d} data matrix. (2) A \code{d} by \code{d} sample covariance covariance matrix. The program automatically identifies the input matrix by checking the symmetry.(\code{n} is the sample size and \code{d} is the dimension).
}
  \item{lambda}{
A sequence of decresing positive numbers to control the thresholding in GECT. Typical usage is to leave the input \code{lambda = NULL} and have the program compute its own \code{lambda} sequence based on \code{nlambda} and \code{lambda.min.ratio}. Users can also specify a sequence to override it.
}
  \item{nlambda}{
The number of thresholding paramters. The default value is \code{20}.
}
  \item{lambda.min.ratio}{
The largest sparsity level for estimated graphs. The program can automatically generate \code{lambda} as a sequence of length = \code{nlambda}, which makes the sparsity level of the graph path increases from \code{0} to \code{lambda.min.ratio} evenly. The default value is \code{0.05}. 
}
  \item{verbose}{
If \code{verbose = FALSE}, printing the tracing information is disabled. The default value is \code{TRUE}.
}
}

\details{
Under the assumption of sparsity, Graph Estimation via Correlation Thresholding (GECT) is the most efficient way to study the underlying structure of Gaussian graphical models regardless the expected sparsity level. As an approximation of paritial correlation graph estimation, GECT also performs well. It can generate some dense graphs, while the sparsity level generated by L1 regularization methods usually depends on the sample size.
}

\value{
An object with S3 class "GECT" is returned:
  \item{path}{
A list of \code{k} by \code{k} adjacency matrices (in sparse matrix representation) of estimated graphs as the solution path corresponding to \code{lambda}.
}
  \item{cov.input}{
An indicator of the sample covariance.
}
  \item{lambda}{
The sequence of thresholding parameters used in GECT.
}
  \item{sparsity}{
The sparsity levels of the graph path.
}
}

\author{
Tuo Zhao, Han Liu, Kathryn Roeder, John Lafferty, and Larry Wasserman \cr
Maintainers: Tuo Zhao<tourzhao@gmail.com>; Han Liu <hanliu@cs.jhu.edu>
}

\references{
1.Tuo Zhao and Han Liu. HUGE: A Package for High-dimensional Undirected Graph Estimation. \emph{Technical Report}, Carnegie Mellon University, 2010\cr
2.Jerome Friedman, Trevor Hastie and Rob Tibshiran. Applications of the lasso and grouped lasso to the estimation of sparse graphical models, \emph{Technical Report}, Stanford University, 2010
}

\seealso{
\code{\link{huge}} and \code{\link{huge-package}}
}

\examples{
# generate data
L = huge.generator(graph = "hub", g = 5)

# the Graph Estimation via Correlation Threholding (GECT)
out = huge.GECT(L$data, nlambda = 20)
plot(out)
}