\name{http_status}
\alias{http_status}
\title{Give information on the status of a request.}
\usage{
  http_status(x)
}
\arguments{
  \item{x}{a request object}
}
\value{
  If the status code does not match a known status, the
  function errors out.  Otherwise, it returns a list with
  components \item{category}{the broad category of the
  status} \item{message}{the meaning of the status code}
}
\description{
  Extract the http status code and convert it into a human
  readable message.
}
\details{
  http servers send a status code with the response to each
  request. This code gives information regarding the
  outcome of the execution of the request on the server.
  Roughly, codes in the 200s mean the request was
  successfully executed; codes in the 300s mean the page
  was redirected; codes in the 400s mean there was a
  mistake in the way the client sent the request; codes in
  the 500s mean the server failed to fulfill an apparently
  valid request. More details on the codes can be found at
  \code{http://en.wikipedia.org/wiki/Http_error_codes}.
}
\examples{
x <- GET("http://httpbin.org/status/200")
http_status(x)

http_status(GET("http://httpbin.org/status/300"))
http_status(GET("http://httpbin.org/status/301"))
http_status(GET("http://httpbin.org/status/404"))

# errors out on unknown status
\dontrun{http_status(GET("http://httpbin.org/status/320"))}
}
\seealso{
  Other response methods: \code{\link{content}},
  \code{\link{http_error}}, \code{\link{response}},
  \code{\link{stop_for_status}}, \code{\link{url_ok}},
  \code{\link{url_success}}, \code{\link{warn_for_status}}
}

