% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/capture-requests.R
\name{capture_requests}
\alias{capture_requests}
\alias{start_capturing}
\alias{stop_capturing}
\title{Record API responses as mock files}
\usage{
capture_requests(expr, path, ...)

start_capturing(path = NULL, simplify = TRUE)

stop_capturing()
}
\arguments{
\item{expr}{Code to run inside the context}

\item{path}{Where to save the mock files. Default is the first directory in
\code{\link[=.mockPaths]{.mockPaths()}}, which if not otherwise specified is the current working
directory. It is generally better to call \code{.mockPaths()} directly if you
want to write to a different path, rather than using the \code{path} argument.}

\item{...}{Arguments passed through \code{capture_requests} to \code{start_capturing}}

\item{simplify}{logical: if \code{TRUE} (default), JSON responses with status 200
will be written as just the text of the response body. In all other cases,
and when \code{simplify} is \code{FALSE}, the "response" object will be written out to
a .R file using \code{\link[base:dput]{base::dput()}}.}
}
\value{
\code{capture_requests} returns the result of \code{expr}. \code{start_capturing}
invisibly returns the \code{path} it is given. \code{stop_capturing} returns nothing;
it is called for its side effects.
}
\description{
\code{capture_requests} is a context that collects the responses from requests
you make and stores them as mock files. This enables you to perform a series
of requests against a live server once and then build your test suite using
those mocks, running your tests in \code{\link[=with_mock_api]{with_mock_api()}}.
}
\details{
\code{start_capturing} and \code{stop_capturing} allow you to turn on/off request
recording for more convenient use in an interactive session.

Recorded responses are written out as plain-text files. By storing fixtures
as plain-text files, you can
more easily confirm that your mocks look correct, and you can more easily
maintain them without having to re-record them. If the API changes subtly,
such as when adding an additional attribute to an object, you can just touch
up the mocks.

If the response has status \verb{200 OK} and the \code{Content-Type}
maps to a supported file extension---currently \code{.json},
\code{.html}, \code{.xml}, \code{.txt}, \code{.csv}, and \code{.tsv}---just the response body will be
written out, using the appropriate extension. \verb{204 No Content} status
responses will be stored as an empty file with extension \code{.204}. Otherwise,
the response will be written as a \code{.R} file containing syntax that, when
executed, recreates the
\code{httr} "response" object.

If you have trouble when recording responses, or are unsure where the files
are being written, set \code{options(httptest.verbose=TRUE)} to print a message
for every file that is written containing the absolute path of the file.
}
\examples{
\dontrun{
capture_requests({
    GET("http://httpbin.org/get")
    GET("http://httpbin.org")
    GET("http://httpbin.org/response-headers",
        query=list(`Content-Type`="application/json"))
})
# Or:
start_capturing()
GET("http://httpbin.org/get")
GET("http://httpbin.org")
GET("http://httpbin.org/response-headers",
    query=list(`Content-Type`="application/json"))
stop_capturing()
}
}
\seealso{
\code{\link[=build_mock_url]{build_mock_url()}} for how requests are translated to file paths.
And see \code{vignette("redacting")} for details on how to prune sensitive
content from responses when recording.
}
