\name{chem.invivo.PK.summary.data}
\docType{data}
\alias{chem.invivo.PK.summary.data}
\title{Summary of published toxicokinetic time course experiments}
\description{
This data set summarizes the time course data in the chem.invivo.PK.data table.
Maximum concentration (Cmax), time integrated plasma concentration for the
duration of treatment (AUC.treatment) and extrapolated to zero concentration
(AUC.infinity) as well as half-life are calculated. Summary values are given
for each study and dosage. These data can be used to evaluate toxicokinetic model
predictions.}
\usage{chem.invivo.PK.summary.data}
\format{A data.frame containing 100 rows and 25 columns.}
\source{Wambaugh et al. 2018 Toxicological Sciences, in press}
\references{
Aanderud L, Bakke OM (1983). Pharmacokinetics of antipyrine, paracetamol, and morphine in rat at 71 ATA. Undersea Biomed Res. 10(3):193-201. PMID: 6636344

Aasmoe L, Mathiesen M, Sager G (1999). Elimination of methoxyacetic acid and ethoxyacetic acid in rat. Xenobiotica. 29(4):417-24. PMID: 10375010

Ako RA. Pharmacokinetics/pharmacodynamics (PK/PD) of oral diethylstilbestrol (DES) in recurrent prostate cancer patients and of oral dissolving film (ODF)-DES in rats. PhD dissertation, College of Pharmacy, University of Houston, USA, 2011.

Anadon A, Martinez-Larranaga MR, Fernandez-Cruz ML, Diaz MJ, Fernandez MC, Martinez MA (1996). Toxicokinetics of deltamethrin and its 4'-HO-metabolite in the rat. Toxicol Appl Pharmacol. 141(1):8-16. PMID: 8917670

Binkerd PE, Rowland JM, Nau H, Hendrickx AG (1988). Evaluation of valproic acid (VPA) developmental toxicity and pharmacokinetics in Sprague-Dawley rats. Fundam Appl Toxicol. 11(3):485-93. PMID: 3146521

Boralli VB, Coelho EB, Cerqueira PM, Lanchote VL (2005). Stereoselective analysis of metoprolol and its metabolites in rat plasma with application to oxidative metabolism. J Chromatogr B Analyt Technol Biomed Life Sci. 823(2):195-202. PMID: 16029965

Chan MP, Morisawa S, Nakayama A, Kawamoto Y, Sugimoto M, Yoneda M (2005). Toxicokinetics of 14C-endosulfan in male Sprague-Dawley rats following oral administration of single or repeated doses. Environ Toxicol. 20(5):533-41. PMID: 16161119

Cruz L, Castaneda-Hernandez G, Flores-Murrieta FJ, Garcia-Lopez P, Guizar-Sahagun G (2002). Alteration of phenacetin pharmacokinetics after experimental spinal cord injury. Proc West Pharmacol Soc. 45:4-5. PMID: 12434508

Della Paschoa OE, Mandema JW, Voskuyl RA, Danhof M (1998). Pharmacokinetic-pharmacodynamic modeling of the anticonvulsant and electroencephalogram effects of phenytoin in rats. J Pharmacol Exp Ther. 284(2):460-6. PMID: 9454785

Du B, Li X, Yu Q, A Y, Chen C (2010). Pharmacokinetic comparison of orally disintegrating, beta-cyclodextrin inclusion complex and conventional tablets of nicardipine in rats. Life Sci J. 7(2):80-4.

Farris FF, Dedrick RL, Allen PV, Smith JC (1993). Physiological model for the pharmacokinetics of methyl mercury in the growing rat. Toxicol Appl Pharmacol. 119(1):74-90. PMID: 8470126

Hays SM, Elswick BA, Blumenthal GM, Welsch F, Conolly RB, Gargas ML (2000). Development of a physiologically based pharmacokinetic model of 2-methoxyethanol and 2-methoxyacetic acid disposition in pregnant rats. Toxicol Appl Pharmacol. 163(1):67-74. PMID: 10662606

Igari Y, Sugiyama Y, Awazu S, Hanano M (1982). Comparative physiologically based pharmacokinetics of hexobarbital, phenobarbital and thiopental in the rat. J Pharmacokinet Biopharm. 10(1):53-75. PMID: 7069578

Ito K, Houston JB (2004). Comparison of the use of liver models for predicting drug clearance using in vitro kinetic data from hepatic microsomes and isolated hepatocytes. Pharm Res. 21(5):785-92. PMID: 15180335

Jia L, Wong H, Wang Y, Garza M, Weitman SD (2003). Carbendazim: disposition, cellular permeability, metabolite identification, and pharmacokinetic comparison with its nanoparticle. J Pharm Sci. 92(1):161-72. PMID: 12486692

Kawai R, Mathew D, Tanaka C, Rowland M (1998). Physiologically based pharmacokinetics of cyclosporine A: extension to tissue distribution kinetics in rats and scale-up to human. J Pharmacol Exp Ther. 287(2):457-68. PMID: 9808668

Kim YC, Kang HE, Lee MG (2008). Pharmacokinetics of phenytoin and its metabolite, 4'-HPPH, after intravenous and oral administration of phenytoin to diabetic rats induced by alloxan or streptozotocin. Biopharm Drug Dispos. 29(1):51-61. PMID: 18022993

Kobayashi S, Takai K, Iga T, Hanano M (1991). Pharmacokinetic analysis of the disposition of valproate in pregnant rats. Drug Metab Dispos. 19(5):972-6. PMID: 1686245

Kotegawa T, Laurijssens BE, Von Moltke LL, Cotreau MM, Perloff MD, Venkatakrishnan K, Warrington JS, Granda BW, Harmatz JS, Greenblatt DJ (2002). In vitro, pharmacokinetic, and pharmacodynamic interactions of ketoconazole and midazolam in the rat. J Pharmacol Exp Ther. 302(3):1228-37. PMID: 12183684

Krug AK, Kolde R, Gaspar JA, Rempel E, Balmer NV, Meganathan K, Vojnits K, Baquie M, Waldmann T, Ensenat-Waser R, Jagtap S, Evans RM, Julien S, Peterson H, Zagoura D, Kadereit S, Gerhard D, Sotiriadou I, Heke M, Natarajan K, Henry M, Winkler J, Marchan R, Stoppini L, Bosgra S, Westerhout J, Verwei M, Vilo J, Kortenkamp A, Hescheler J, Hothorn L, Bremer S, van Thriel C, Krause KH, Hengstler JG, Rahnenfuhrer J, Leist M, Sachinidis A (2013). Human embryonic stem cell-derived test systems for developmental neurotoxicity: a transcriptomics approach. Arch Toxicol. 87(1):123-43. PMID: 23179753

Leon-Reyes MR, Castaneda-Hernandez G, Ortiz MI (2009). Pharmacokinetic of diclofenac in the presence and absence of glibenclamide in the rat. J Pharm Pharm Sci. 12(3):280-7. PMID: 20067705

Nagata M, Hidaka M, Sekiya H, Kawano Y, Yamasaki K, Okumura M, Arimori K (2007). Effects of pomegranate juice on human cytochrome P450 2C9 and tolbutamide pharmacokinetics in rats. Drug Metab Dispos. 35(2):302-5. PMID: 17132763

Okiyama M, Ueno K, Ohmori S, Igarashi T, Kitagawa H (1988). Drug interactions between imipramine and benzodiazepines in rats. J Pharm Sci. 77(1):56-63. PMID: 2894451

Pelissier-Alicot AL, Schreiber-Deturmeny E, Simon N, Gantenbein M, Bruguerolle B (2002). Time-of-day dependent pharmacodynamic and pharmacokinetic profiles of caffeine in rats. Naunyn Schmiedebergs Arch Pharmacol. 365(4):318-25. PMID: 11919657

Piersma AH, Bosgra S, van Duursen MB, Hermsen SA, Jonker LR, Kroese ED, van der Linden SC, Man H, Roelofs MJ, Schulpen SH, Schwarz M, Uibel F, van Vugt-Lussenburg BM, Westerhout J, Wolterbeek AP, van der Burg B (2013). Evaluation of an alternative in vitro test battery for detecting reproductive toxicants. Reprod Toxicol. 38:53-64. PMID: 23511061

Pollack GM, Li RC, Ermer JC, Shen DD (1985). Effects of route of administration and repetitive dosing on the disposition kinetics of di(2-ethylhexyl) phthalate and its mono-de-esterified metabolite in rats. Toxicol Appl Pharmacol. Jun 30;79(2):246-56. PMID: 4002226

Saadeddin A, Torres-Molina F, Carcel-Trullols J, Araico A, Peris JE (2004). Pharmacokinetics of the time-dependent elimination of all-trans-retinoic acid in rats. AAPS J. 6(1):1-9. PMID: 18465253

Satterwhite JH, Boudinot FD (1991). Effects of age and dose on the pharmacokinetics of ibuprofen in the rat. Drug Metab Dispos. 19(1):61-7. PMID: 1673423

Szymura-Oleksiak J, Panas M, Chrusciel W (1983). Pharmacokinetics of imipramine after single and multiple intravenous administration in rats. Pol J Pharmacol Pharm. 35(2):151-7. PMID: 6622297

Tanaka C, Kawai R, Rowland M (2000). Dose-dependent pharmacokinetics of cyclosporin A in rats: events in tissues. Drug Metab Dispos. 28(5):582-9. PMID: 10772639

Timchalk C, Nolan RJ, Mendrala AL, Dittenber DA, Brzak KA, Mattsson JL (2002). A Physiologically based pharmacokinetic and pharmacodynamic (PBPK/PD) model for the organophosphate insecticide chlorpyrifos in rats and humans. Toxicol Sci. Mar;66(1):34-53. PMID: 11861971

Tokuma Y, Sekiguchi M, Niwa T, Noguchi H (1988). Pharmacokinetics of nilvadipine, a new dihydropyridine calcium antagonist, in mice, rats, rabbits and dogs. Xenobiotica 18(1):21-8. PMID: 3354229

Treiber A, Schneiter R, Delahaye S, Clozel M (2004). Inhibition of organic anion transporting polypeptide-mediated hepatic uptake is the major determinant in the pharmacokinetic interaction between bosentan and cyclosporin A in the rat. J Pharmacol Exp Ther. 308(3):1121-9. PMID: 14617681

Tsui BC, Feng JD, Buckley SJ, Yeung PK (1994). Pharmacokinetics and metabolism of diltiazem in rats following a single intra-arterial or single oral dose. Eur J Drug Metab Pharmacokinet. 19(4):369-73. PMID: 7737239

Wambaugh, John F., et al. "Toxicokinetic triage for environmental chemicals." Toxicological Sciences (2015): 228-237.

Wang Y, Roy A, Sun L, Lau CE (1999). A double-peak phenomenon in the pharmacokinetics of alprazolam after oral administration. Drug Metab Dispos. 27(8):855-9. PMID: 10421610

Wang X, Lee WY, Or PM, Yeung JH (2010). Pharmacokinetic interaction studies of tanshinones with tolbutamide, a model CYP2C11 probe substrate, using liver microsomes, primary hepatocytes and in vivo in the rat. Phytomedicine. 17(3-4):203-11. PMID: 19679455

Yang SH, Lee MG (2008). Dose-independent pharmacokinetics of ondansetron in rats: contribution of hepatic and intestinal first-pass effects to low bioavailability. Biopharm Drug Dispos. 29(7):414-26. PMID: 18697186

Yeung PK, Alcos A, Tang J (2009). Pharmacokinetics and Hemodynamic Effects of Diltiazem in Rats Following Single vs Multiple Doses In Vivo. Open Drug Metab J. 3:56-62.
}
\author{
John Wambaugh
}
\keyword{ datasets }
