% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_hypso.R
\name{p_hypso}
\alias{p_hypso}
\title{Plot the hypsometry curve of one or more basins}
\usage{
p_hypso(
  file_mnt,
  abbrev,
  prop = FALSE,
  range = 50,
  fact = 5,
  title = "Title",
  savefig = FALSE,
  width = 8,
  height = 6,
  fileo = "plot.png"
)
}
\arguments{
\item{file_mnt}{Raster file list of elevation model of basin(s)}

\item{abbrev}{List of abbreviated basin name(s)}

\item{prop}{TRUE / FALSE (defaut) plot a proportion curve of altitude ranges}

\item{range}{Width of altitude range (default = 50m)}

\item{fact}{Exagerating factor of the areas (default=5)}

\item{title}{Title of the plot (default = Title)}

\item{savefig}{Save the plot in png (default FALSE)}

\item{width}{Plot width (x 100 pixels) (default = 8)}

\item{height}{Plot height (x 100 pixels) (default = 6)}

\item{fileo}{Name of plot file with extension (default = "plot.png")}
}
\value{
An object of ggplot2 class
}
\description{
Plot the hypsometry curve of one or more basins
}
\details{
This function uses the "raster" library and the dependencies "sp" and "rgdal",
which must be installed.
}
\author{
P. Chevallier - Sep 2017- Jan 2019
}
